/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.TimerListener;
import org.apache.camel.support.TimerListenerManager;

public class TimerListenerManagerTest
extends ContextTestSupport {
    private final MyTask task = new MyTask();

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testTimerListenerManager() throws Exception {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        TimerListenerManager manager = new TimerListenerManager();
        manager.setCamelContext((CamelContext)this.context);
        manager.addTimerListener((TimerListener)this.task);
        manager.start();
        TimerListenerManagerTest.assertTrue((String)"Should be invoked", (boolean)this.task.await());
        manager.stop();
        manager.removeTimerListener((TimerListener)this.task);
        executor.shutdown();
    }

    private class MyTask
    implements TimerListener {
        private CountDownLatch latch = new CountDownLatch(1);

        private MyTask() {
        }

        public void onTimer() {
            this.latch.countDown();
        }

        public boolean await() throws InterruptedException {
            return this.latch.await(5L, TimeUnit.SECONDS);
        }
    }
}

