/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import junit.framework.TestCase;
import org.apache.camel.support.XMLTokenExpressionIterator;

public class XMLTokenExpressionIteratorCharsetTest
extends TestCase {
    private static final String DATA_TEMPLATE = "<?xml version=\"1.0\" encoding=\"{0}\"?><Statements xmlns=\"http://www.apache.org/xml/test\">    <statement>we l\u00f3ve iso-latin</statement>    <statement>we h\u00e4te unicode</statement></Statements>";
    private static final String[] RESULTS = new String[]{"<statement xmlns=\"http://www.apache.org/xml/test\">we l\u00f3ve iso-latin</statement>", "<statement xmlns=\"http://www.apache.org/xml/test\">we h\u00e4te unicode</statement>"};
    private static final String DATA_STRING = MessageFormat.format("<?xml version=\"1.0\" encoding=\"{0}\"?><Statements xmlns=\"http://www.apache.org/xml/test\">    <statement>we l\u00f3ve iso-latin</statement>    <statement>we h\u00e4te unicode</statement></Statements>", "utf-8");
    private static final byte[] DATA_UTF8 = XMLTokenExpressionIteratorCharsetTest.getBytes("<?xml version=\"1.0\" encoding=\"{0}\"?><Statements xmlns=\"http://www.apache.org/xml/test\">    <statement>we l\u00f3ve iso-latin</statement>    <statement>we h\u00e4te unicode</statement></Statements>", "utf-8");
    private static final byte[] DATA_ISOLATIN = XMLTokenExpressionIteratorCharsetTest.getBytes("<?xml version=\"1.0\" encoding=\"{0}\"?><Statements xmlns=\"http://www.apache.org/xml/test\">    <statement>we l\u00f3ve iso-latin</statement>    <statement>we h\u00e4te unicode</statement></Statements>", "iso-8859-1");
    private static final Map<String, String> NSMAP = Collections.singletonMap("", "http://www.apache.org/xml/test");

    private static byte[] getBytes(String template, String charset) {
        try {
            return MessageFormat.format(template, charset).getBytes(charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public void testTokenzeWithUTF8() throws Exception {
        XMLTokenExpressionIterator xtei = new XMLTokenExpressionIterator("//statement", 'i');
        xtei.setNamespaces(NSMAP);
        this.invokeAndVerify(xtei.createIterator((InputStream)new ByteArrayInputStream(DATA_UTF8), "utf-8"));
    }

    public void testTokenizeWithISOLatin() throws Exception {
        XMLTokenExpressionIterator xtei = new XMLTokenExpressionIterator("//statement", 'i');
        xtei.setNamespaces(NSMAP);
        this.invokeAndVerify(xtei.createIterator((InputStream)new ByteArrayInputStream(DATA_ISOLATIN), "iso-8859-1"));
    }

    public void testTokenizeWithReader() throws Exception {
        XMLTokenExpressionIterator xtei = new XMLTokenExpressionIterator("//statement", 'i');
        xtei.setNamespaces(NSMAP);
        this.invokeAndVerify(xtei.createIterator((Reader)new StringReader(DATA_STRING)));
    }

    private void invokeAndVerify(Iterator<?> tokenizer) throws IOException, XMLStreamException {
        ArrayList<String> results = new ArrayList<String>();
        while (tokenizer.hasNext()) {
            String token = (String)tokenizer.next();
            results.add(token);
        }
        ((Closeable)((Object)tokenizer)).close();
        XMLTokenExpressionIteratorCharsetTest.assertEquals((String)"token count", (int)RESULTS.length, (int)results.size());
        for (int i = 0; i < RESULTS.length; ++i) {
            XMLTokenExpressionIteratorCharsetTest.assertEquals((String)("mismatch [" + i + "]"), (String)RESULTS[i], (String)((String)results.get(i)));
        }
    }
}

