/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import junit.framework.TestCase;
import org.apache.camel.support.XMLTokenExpressionIterator;

public class XMLTokenExpressionIteratorInvalidXMLTest
extends TestCase {
    private static final String DATA_TEMPLATE = "<?xml version=\"1.0\" encoding=\"utf-u\"?><Statements xmlns=\"http://www.apache.org/xml/test\">    <statement>Hello World</statement>    <statement>{0}</statement></Statements>";
    private static final Map<String, String> NSMAP = Collections.singletonMap("", "http://www.apache.org/xml/test");

    public void testExtractToken() throws Exception {
        String data = MessageFormat.format(DATA_TEMPLATE, "Have a nice day");
        XMLTokenExpressionIterator xtei = new XMLTokenExpressionIterator("//statement", 'i');
        xtei.setNamespaces(NSMAP);
        this.invokeAndVerify(xtei.createIterator((Reader)new StringReader(data)), false);
        data = MessageFormat.format(DATA_TEMPLATE, "Have a nice< day");
        xtei = new XMLTokenExpressionIterator("//statement", 'i');
        xtei.setNamespaces(NSMAP);
        this.invokeAndVerify(xtei.createIterator((Reader)new StringReader(data)), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAndVerify(Iterator<?> tokenizer, boolean error) throws IOException, XMLStreamException {
        Exception exp = null;
        try {
            tokenizer.next();
            tokenizer.next();
        }
        catch (Exception e) {
            exp = e;
        }
        finally {
            ((Closeable)((Object)tokenizer)).close();
        }
        if (error) {
            XMLTokenExpressionIteratorInvalidXMLTest.assertNotNull((String)"the error expected", (Object)exp);
        } else {
            XMLTokenExpressionIteratorInvalidXMLTest.assertNull((String)"no error expected", (Object)exp);
        }
    }
}

