/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.File;
import junit.framework.TestCase;
import org.apache.camel.util.FileUtil;

public class FileUtilTest
extends TestCase {
    public void testNormalizePath() {
        if (FileUtil.isWindows()) {
            FileUtilTest.assertEquals((String)"foo\\bar", (String)FileUtil.normalizePath((String)"foo/bar"));
            FileUtilTest.assertEquals((String)"foo\\bar\\baz", (String)FileUtil.normalizePath((String)"foo/bar\\baz"));
            FileUtilTest.assertEquals((String)"movefile\\sub\\sub2\\.done\\goodday.txt", (String)FileUtil.normalizePath((String)"movefile/sub/sub2\\.done\\goodday.txt"));
        } else {
            FileUtilTest.assertEquals((String)"foo/bar", (String)FileUtil.normalizePath((String)"foo/bar"));
            FileUtilTest.assertEquals((String)"foo/bar/baz", (String)FileUtil.normalizePath((String)"foo/bar\\baz"));
            FileUtilTest.assertEquals((String)"movefile/sub/sub2/.done/goodday.txt", (String)FileUtil.normalizePath((String)"movefile/sub/sub2\\.done\\goodday.txt"));
        }
    }

    public void testStripLeadingSeparator() {
        FileUtilTest.assertEquals(null, (String)FileUtil.stripLeadingSeparator(null));
        FileUtilTest.assertEquals((String)"foo", (String)FileUtil.stripLeadingSeparator((String)"foo"));
        FileUtilTest.assertEquals((String)"foo/bar", (String)FileUtil.stripLeadingSeparator((String)"foo/bar"));
        FileUtilTest.assertEquals((String)"foo/", (String)FileUtil.stripLeadingSeparator((String)"foo/"));
        FileUtilTest.assertEquals((String)"foo/bar", (String)FileUtil.stripLeadingSeparator((String)"/foo/bar"));
        FileUtilTest.assertEquals((String)"foo/bar", (String)FileUtil.stripLeadingSeparator((String)"//foo/bar"));
        FileUtilTest.assertEquals((String)"foo/bar", (String)FileUtil.stripLeadingSeparator((String)"///foo/bar"));
    }

    public void testHasLeadingSeparator() {
        FileUtilTest.assertEquals((boolean)false, (boolean)FileUtil.hasLeadingSeparator(null));
        FileUtilTest.assertEquals((boolean)false, (boolean)FileUtil.hasLeadingSeparator((String)"foo"));
        FileUtilTest.assertEquals((boolean)false, (boolean)FileUtil.hasLeadingSeparator((String)"foo/bar"));
        FileUtilTest.assertEquals((boolean)false, (boolean)FileUtil.hasLeadingSeparator((String)"foo/"));
        FileUtilTest.assertEquals((boolean)true, (boolean)FileUtil.hasLeadingSeparator((String)"/foo/bar"));
        FileUtilTest.assertEquals((boolean)true, (boolean)FileUtil.hasLeadingSeparator((String)"//foo/bar"));
        FileUtilTest.assertEquals((boolean)true, (boolean)FileUtil.hasLeadingSeparator((String)"///foo/bar"));
    }

    public void testStripFirstLeadingSeparator() {
        FileUtilTest.assertEquals(null, (String)FileUtil.stripFirstLeadingSeparator(null));
        FileUtilTest.assertEquals((String)"foo", (String)FileUtil.stripFirstLeadingSeparator((String)"foo"));
        FileUtilTest.assertEquals((String)"foo/bar", (String)FileUtil.stripFirstLeadingSeparator((String)"foo/bar"));
        FileUtilTest.assertEquals((String)"foo/", (String)FileUtil.stripFirstLeadingSeparator((String)"foo/"));
        FileUtilTest.assertEquals((String)"foo/bar", (String)FileUtil.stripFirstLeadingSeparator((String)"/foo/bar"));
        FileUtilTest.assertEquals((String)"/foo/bar", (String)FileUtil.stripFirstLeadingSeparator((String)"//foo/bar"));
        FileUtilTest.assertEquals((String)"//foo/bar", (String)FileUtil.stripFirstLeadingSeparator((String)"///foo/bar"));
    }

    public void testStripTrailingSeparator() {
        FileUtilTest.assertEquals(null, (String)FileUtil.stripTrailingSeparator(null));
        FileUtilTest.assertEquals((String)"foo", (String)FileUtil.stripTrailingSeparator((String)"foo"));
        FileUtilTest.assertEquals((String)"foo/bar", (String)FileUtil.stripTrailingSeparator((String)"foo/bar"));
        FileUtilTest.assertEquals((String)"foo", (String)FileUtil.stripTrailingSeparator((String)"foo/"));
        FileUtilTest.assertEquals((String)"foo/bar", (String)FileUtil.stripTrailingSeparator((String)"foo/bar/"));
        FileUtilTest.assertEquals((String)"/foo/bar", (String)FileUtil.stripTrailingSeparator((String)"/foo/bar"));
        FileUtilTest.assertEquals((String)"/foo/bar", (String)FileUtil.stripTrailingSeparator((String)"/foo/bar/"));
        FileUtilTest.assertEquals((String)"/foo/bar", (String)FileUtil.stripTrailingSeparator((String)"/foo/bar//"));
        FileUtilTest.assertEquals((String)"/foo/bar", (String)FileUtil.stripTrailingSeparator((String)"/foo/bar///"));
        FileUtilTest.assertEquals((String)"/foo", (String)FileUtil.stripTrailingSeparator((String)"/foo"));
        FileUtilTest.assertEquals((String)"/foo", (String)FileUtil.stripTrailingSeparator((String)"/foo/"));
        FileUtilTest.assertEquals((String)"/", (String)FileUtil.stripTrailingSeparator((String)"/"));
        FileUtilTest.assertEquals((String)"//", (String)FileUtil.stripTrailingSeparator((String)"//"));
    }

    public void testStripPath() {
        FileUtilTest.assertEquals(null, (String)FileUtil.stripPath(null));
        FileUtilTest.assertEquals((String)"", (String)FileUtil.stripPath((String)"/"));
        FileUtilTest.assertEquals((String)"foo.xml", (String)FileUtil.stripPath((String)"/foo.xml"));
        FileUtilTest.assertEquals((String)"foo", (String)FileUtil.stripPath((String)"foo"));
        FileUtilTest.assertEquals((String)"bar", (String)FileUtil.stripPath((String)"foo/bar"));
        FileUtilTest.assertEquals((String)"bar", (String)FileUtil.stripPath((String)"/foo/bar"));
    }

    public void testStripPathWithMixedSeparators() {
        FileUtilTest.assertEquals(null, (String)FileUtil.stripPath(null));
        FileUtilTest.assertEquals((String)"", (String)FileUtil.stripPath((String)"/"));
        FileUtilTest.assertEquals((String)"foo.xml", (String)FileUtil.stripPath((String)"/foo.xml"));
        FileUtilTest.assertEquals((String)"foo", (String)FileUtil.stripPath((String)"foo"));
        FileUtilTest.assertEquals((String)"baz", (String)FileUtil.stripPath((String)"foo/bar\\baz"));
        FileUtilTest.assertEquals((String)"bar", (String)FileUtil.stripPath((String)"\\foo\\bar"));
        FileUtilTest.assertEquals((String)"baz", (String)FileUtil.stripPath((String)"/foo\\bar/baz"));
    }

    public void testStripExt() {
        FileUtilTest.assertEquals(null, (String)FileUtil.stripExt(null));
        FileUtilTest.assertEquals((String)"foo", (String)FileUtil.stripExt((String)"foo"));
        FileUtilTest.assertEquals((String)"foo", (String)FileUtil.stripExt((String)"foo.xml"));
        FileUtilTest.assertEquals((String)"/foo/bar", (String)FileUtil.stripExt((String)"/foo/bar.xml"));
    }

    public void testOnlyPath() {
        FileUtilTest.assertEquals(null, (String)FileUtil.onlyPath(null));
        FileUtilTest.assertEquals(null, (String)FileUtil.onlyPath((String)"foo"));
        FileUtilTest.assertEquals(null, (String)FileUtil.onlyPath((String)"foo.xml"));
        FileUtilTest.assertEquals((String)"foo", (String)FileUtil.onlyPath((String)"foo/bar.xml"));
        FileUtilTest.assertEquals((String)"/foo", (String)FileUtil.onlyPath((String)"/foo/bar.xml"));
        FileUtilTest.assertEquals((String)"/foo/bar", (String)FileUtil.onlyPath((String)"/foo/bar/baz.xml"));
        FileUtilTest.assertEquals((String)"/", (String)FileUtil.onlyPath((String)"/foo.xml"));
        FileUtilTest.assertEquals((String)"/bar", (String)FileUtil.onlyPath((String)"/bar/foo.xml"));
    }

    public void testOnlyPathWithMixedSeparators() {
        FileUtilTest.assertEquals(null, (String)FileUtil.onlyPath(null));
        FileUtilTest.assertEquals(null, (String)FileUtil.onlyPath((String)"foo"));
        FileUtilTest.assertEquals(null, (String)FileUtil.onlyPath((String)"foo.xml"));
        FileUtilTest.assertEquals((String)"foo", (String)FileUtil.onlyPath((String)"foo/bar.xml"));
        FileUtilTest.assertEquals((String)"/foo", (String)FileUtil.onlyPath((String)"/foo\\bar.xml"));
        FileUtilTest.assertEquals((String)"\\foo\\bar", (String)FileUtil.onlyPath((String)"\\foo\\bar/baz.xml"));
        FileUtilTest.assertEquals((String)"\\", (String)FileUtil.onlyPath((String)"\\foo.xml"));
        FileUtilTest.assertEquals((String)"/bar", (String)FileUtil.onlyPath((String)"/bar\\foo.xml"));
    }

    public void testCompactPath() {
        FileUtilTest.assertEquals(null, (String)FileUtil.compactPath(null));
        if (FileUtil.isWindows()) {
            FileUtilTest.assertEquals((String)"..\\foo", (String)FileUtil.compactPath((String)"..\\foo"));
            FileUtilTest.assertEquals((String)"..\\..\\foo", (String)FileUtil.compactPath((String)"..\\..\\foo"));
            FileUtilTest.assertEquals((String)"..\\..\\foo\\bar", (String)FileUtil.compactPath((String)"..\\..\\foo\\bar"));
            FileUtilTest.assertEquals((String)"..\\..\\foo", (String)FileUtil.compactPath((String)"..\\..\\foo\\bar\\.."));
            FileUtilTest.assertEquals((String)"foo", (String)FileUtil.compactPath((String)"foo"));
            FileUtilTest.assertEquals((String)"bar", (String)FileUtil.compactPath((String)"foo\\..\\bar"));
            FileUtilTest.assertEquals((String)"bar\\baz", (String)FileUtil.compactPath((String)"foo\\..\\bar\\baz"));
            FileUtilTest.assertEquals((String)"foo\\baz", (String)FileUtil.compactPath((String)"foo\\bar\\..\\baz"));
            FileUtilTest.assertEquals((String)"baz", (String)FileUtil.compactPath((String)"foo\\bar\\..\\..\\baz"));
            FileUtilTest.assertEquals((String)"..\\baz", (String)FileUtil.compactPath((String)"foo\\bar\\..\\..\\..\\baz"));
            FileUtilTest.assertEquals((String)"..\\foo\\bar", (String)FileUtil.compactPath((String)"..\\foo\\bar"));
            FileUtilTest.assertEquals((String)"foo\\bar\\baz", (String)FileUtil.compactPath((String)"foo\\bar\\.\\baz"));
            FileUtilTest.assertEquals((String)"foo\\bar\\baz", (String)FileUtil.compactPath((String)"foo\\bar\\\\baz"));
            FileUtilTest.assertEquals((String)"\\foo\\bar\\baz", (String)FileUtil.compactPath((String)"\\foo\\bar\\baz"));
            FileUtilTest.assertEquals((String)"\\", (String)FileUtil.compactPath((String)"\\"));
            FileUtilTest.assertEquals((String)"\\", (String)FileUtil.compactPath((String)"/"));
            FileUtilTest.assertEquals((String)"/", (String)FileUtil.compactPath((String)"\\", (char)'/'));
            FileUtilTest.assertEquals((String)"/", (String)FileUtil.compactPath((String)"/", (char)'/'));
        } else {
            FileUtilTest.assertEquals((String)"../foo", (String)FileUtil.compactPath((String)"../foo"));
            FileUtilTest.assertEquals((String)"../../foo", (String)FileUtil.compactPath((String)"../../foo"));
            FileUtilTest.assertEquals((String)"../../foo/bar", (String)FileUtil.compactPath((String)"../../foo/bar"));
            FileUtilTest.assertEquals((String)"../../foo", (String)FileUtil.compactPath((String)"../../foo/bar/.."));
            FileUtilTest.assertEquals((String)"foo", (String)FileUtil.compactPath((String)"foo"));
            FileUtilTest.assertEquals((String)"bar", (String)FileUtil.compactPath((String)"foo/../bar"));
            FileUtilTest.assertEquals((String)"bar/baz", (String)FileUtil.compactPath((String)"foo/../bar/baz"));
            FileUtilTest.assertEquals((String)"foo/baz", (String)FileUtil.compactPath((String)"foo/bar/../baz"));
            FileUtilTest.assertEquals((String)"baz", (String)FileUtil.compactPath((String)"foo/bar/../../baz"));
            FileUtilTest.assertEquals((String)"../baz", (String)FileUtil.compactPath((String)"foo/bar/../../../baz"));
            FileUtilTest.assertEquals((String)"../foo/bar", (String)FileUtil.compactPath((String)"../foo/bar"));
            FileUtilTest.assertEquals((String)"foo/bar/baz", (String)FileUtil.compactPath((String)"foo/bar/./baz"));
            FileUtilTest.assertEquals((String)"foo/bar/baz", (String)FileUtil.compactPath((String)"foo/bar//baz"));
            FileUtilTest.assertEquals((String)"/foo/bar/baz", (String)FileUtil.compactPath((String)"/foo/bar/baz"));
            FileUtilTest.assertEquals((String)"/", (String)FileUtil.compactPath((String)"/"));
            FileUtilTest.assertEquals((String)"/", (String)FileUtil.compactPath((String)"\\"));
            FileUtilTest.assertEquals((String)"/", (String)FileUtil.compactPath((String)"/", (char)'/'));
            FileUtilTest.assertEquals((String)"/", (String)FileUtil.compactPath((String)"\\", (char)'/'));
        }
    }

    public void testCompactWindowsStylePath() {
        String path = "E:\\workspace\\foo\\bar\\some-thing\\.\\target\\processes\\2";
        String expected = "E:\\workspace\\foo\\bar\\some-thing\\target\\processes\\2";
        FileUtilTest.assertEquals((String)expected, (String)FileUtil.compactPath((String)path, (char)'\\'));
    }

    public void testCompactPathSeparator() {
        FileUtilTest.assertEquals(null, (String)FileUtil.compactPath(null, (char)'\''));
        FileUtilTest.assertEquals((String)"..\\foo", (String)FileUtil.compactPath((String)"..\\foo", (char)'\\'));
        FileUtilTest.assertEquals((String)"../foo", (String)FileUtil.compactPath((String)"../foo", (char)'/'));
        FileUtilTest.assertEquals((String)"../foo/bar", (String)FileUtil.compactPath((String)"../foo\\bar", (char)'/'));
        FileUtilTest.assertEquals((String)"..\\foo\\bar", (String)FileUtil.compactPath((String)"../foo\\bar", (char)'\\'));
    }

    public void testDefaultTempFileSuffixAndPrefix() throws Exception {
        File tmp = FileUtil.createTempFile((String)"tmp-", (String)".tmp");
        FileUtilTest.assertNotNull((Object)tmp);
        FileUtilTest.assertTrue((String)"Should be a file", (boolean)tmp.isFile());
    }

    public void testDefaultTempFile() throws Exception {
        File tmp = FileUtil.createTempFile(null, null);
        FileUtilTest.assertNotNull((Object)tmp);
        FileUtilTest.assertTrue((String)"Should be a file", (boolean)tmp.isFile());
    }

    public void testDefaultTempFileParent() throws Exception {
        File tmp = FileUtil.createTempFile(null, null, (File)new File("target"));
        FileUtilTest.assertNotNull((Object)tmp);
        FileUtilTest.assertTrue((String)"Should be a file", (boolean)tmp.isFile());
    }

    public void testCreateNewFile() throws Exception {
        File file = new File("target/foo.txt");
        if (file.exists()) {
            FileUtil.deleteFile((File)file);
        }
        FileUtilTest.assertFalse((String)("File should not exist " + file), (boolean)file.exists());
        FileUtilTest.assertTrue((String)("A new file should be created " + file), (boolean)FileUtil.createNewFile((File)file));
    }

    public void testShutdown() throws Exception {
        File tmpFile = FileUtil.createTempFile(null, null);
        File tmpDir = tmpFile.getParentFile();
        FileUtilTest.assertTrue((boolean)tmpDir.exists());
        FileUtil.shutdown();
        FileUtilTest.assertFalse((boolean)tmpDir.exists());
    }

    public void testRenameUsingDelete() throws Exception {
        File file = new File("target/foo.txt");
        if (!file.exists()) {
            FileUtil.createNewFile((File)file);
        }
        File target = new File("target/bar.txt");
        FileUtil.renameFileUsingCopy((File)file, (File)target);
        FileUtilTest.assertTrue((String)"File not copied", (boolean)target.exists());
        FileUtilTest.assertFalse((String)"File not deleted", (boolean)file.exists());
    }
}

