/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import junit.framework.TestCase;
import org.apache.camel.Service;
import org.apache.camel.util.LRUCache;

public class LRUCacheTest
extends TestCase {
    private LRUCache<String, Service> cache;

    protected void setUp() throws Exception {
        this.cache = new LRUCache(10);
    }

    public void testLRUCache() {
        MyService service1 = new MyService();
        MyService service2 = new MyService();
        this.cache.put((Object)"A", (Object)service1);
        this.cache.put((Object)"B", (Object)service2);
        LRUCacheTest.assertEquals((int)2, (int)this.cache.size());
        LRUCacheTest.assertSame((Object)service1, (Object)this.cache.get((Object)"A"));
        LRUCacheTest.assertSame((Object)service2, (Object)this.cache.get((Object)"B"));
    }

    public void testLRUCacheEviction() {
        MyService service1 = new MyService();
        MyService service2 = new MyService();
        MyService service3 = new MyService();
        MyService service4 = new MyService();
        MyService service5 = new MyService();
        MyService service6 = new MyService();
        MyService service7 = new MyService();
        MyService service8 = new MyService();
        MyService service9 = new MyService();
        MyService service10 = new MyService();
        MyService service11 = new MyService();
        MyService service12 = new MyService();
        this.cache.put((Object)"A", (Object)service1);
        LRUCacheTest.assertNull((Object)service1.getStopped());
        this.cache.put((Object)"B", (Object)service2);
        LRUCacheTest.assertNull((Object)service2.getStopped());
        this.cache.put((Object)"C", (Object)service3);
        LRUCacheTest.assertNull((Object)service3.getStopped());
        this.cache.put((Object)"D", (Object)service4);
        LRUCacheTest.assertNull((Object)service4.getStopped());
        this.cache.put((Object)"E", (Object)service5);
        LRUCacheTest.assertNull((Object)service5.getStopped());
        this.cache.put((Object)"F", (Object)service6);
        LRUCacheTest.assertNull((Object)service6.getStopped());
        this.cache.put((Object)"G", (Object)service7);
        LRUCacheTest.assertNull((Object)service7.getStopped());
        this.cache.put((Object)"H", (Object)service8);
        LRUCacheTest.assertNull((Object)service8.getStopped());
        this.cache.put((Object)"I", (Object)service9);
        LRUCacheTest.assertNull((Object)service9.getStopped());
        this.cache.put((Object)"J", (Object)service10);
        LRUCacheTest.assertNull((Object)service10.getStopped());
        LRUCacheTest.assertEquals((int)10, (int)this.cache.size());
        this.cache.put((Object)"K", (Object)service11);
        LRUCacheTest.assertNull((Object)service11.getStopped());
        LRUCacheTest.assertTrue((boolean)service1.getStopped());
        this.cache.put((Object)"L", (Object)service12);
        LRUCacheTest.assertNull((Object)service12.getStopped());
        LRUCacheTest.assertTrue((boolean)service2.getStopped());
        LRUCacheTest.assertEquals((int)10, (int)this.cache.size());
    }

    public void testLRUCacheHitsAndMisses() {
        MyService service1 = new MyService();
        MyService service2 = new MyService();
        this.cache.put((Object)"A", (Object)service1);
        this.cache.put((Object)"B", (Object)service2);
        LRUCacheTest.assertEquals((long)0L, (long)this.cache.getHits());
        LRUCacheTest.assertEquals((long)0L, (long)this.cache.getMisses());
        this.cache.get((Object)"A");
        LRUCacheTest.assertEquals((long)1L, (long)this.cache.getHits());
        LRUCacheTest.assertEquals((long)0L, (long)this.cache.getMisses());
        this.cache.get((Object)"A");
        LRUCacheTest.assertEquals((long)2L, (long)this.cache.getHits());
        LRUCacheTest.assertEquals((long)0L, (long)this.cache.getMisses());
        this.cache.get((Object)"B");
        LRUCacheTest.assertEquals((long)3L, (long)this.cache.getHits());
        LRUCacheTest.assertEquals((long)0L, (long)this.cache.getMisses());
        this.cache.get((Object)"C");
        LRUCacheTest.assertEquals((long)3L, (long)this.cache.getHits());
        LRUCacheTest.assertEquals((long)1L, (long)this.cache.getMisses());
        this.cache.get((Object)"D");
        LRUCacheTest.assertEquals((long)3L, (long)this.cache.getHits());
        LRUCacheTest.assertEquals((long)2L, (long)this.cache.getMisses());
        this.cache.resetStatistics();
        LRUCacheTest.assertEquals((long)0L, (long)this.cache.getHits());
        LRUCacheTest.assertEquals((long)0L, (long)this.cache.getMisses());
        this.cache.get((Object)"B");
        LRUCacheTest.assertEquals((long)1L, (long)this.cache.getHits());
        LRUCacheTest.assertEquals((long)0L, (long)this.cache.getMisses());
        this.cache.clear();
        LRUCacheTest.assertEquals((long)0L, (long)this.cache.getHits());
        LRUCacheTest.assertEquals((long)0L, (long)this.cache.getMisses());
        this.cache.get((Object)"B");
        LRUCacheTest.assertEquals((long)0L, (long)this.cache.getHits());
        LRUCacheTest.assertEquals((long)1L, (long)this.cache.getMisses());
    }

    private static final class MyService
    implements Service {
        private Boolean stopped;

        private MyService() {
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
            this.stopped = true;
        }

        public Boolean getStopped() {
            return this.stopped;
        }
    }
}

