/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jsse;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.camel.CamelContext;
import org.apache.camel.util.jsse.AbstractJsseParametersTest;
import org.apache.camel.util.jsse.AliasedX509ExtendedKeyManager;
import org.apache.camel.util.jsse.KeyManagersParameters;
import org.apache.camel.util.jsse.KeyStoreParameters;

public class KeyManagersParametersTest
extends AbstractJsseParametersTest {
    protected KeyStoreParameters createMinimalKeyStoreParameters() {
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setResource("org/apache/camel/util/jsse/localhost.ks");
        ksp.setPassword("changeit");
        return ksp;
    }

    protected KeyManagersParameters createMinimalKeyManagersParameters() {
        KeyManagersParameters kmp = new KeyManagersParameters();
        kmp.setKeyStore(this.createMinimalKeyStoreParameters());
        kmp.setKeyPassword("changeit");
        return kmp;
    }

    public void testPropertyPlaceholders() throws Exception {
        CamelContext context = this.createPropertiesPlaceholderAwareContext();
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setCamelContext(context);
        ksp.setType("{{keyStoreParameters.type}}");
        ksp.setProvider("{{keyStoreParameters.provider}}");
        ksp.setResource("{{keyStoreParameters.resource}}");
        ksp.setPassword("{{keyStoreParamerers.password}}");
        KeyManagersParameters kmp = new KeyManagersParameters();
        kmp.setCamelContext(context);
        kmp.setKeyStore(ksp);
        kmp.setKeyPassword("{{keyManagersParameters.keyPassword}}");
        kmp.setAlgorithm("{{keyManagersParameters.algorithm}}");
        kmp.setProvider("{{keyManagersParameters.provider}}");
        KeyManager[] kms = kmp.createKeyManagers();
        this.validateKeyManagers(kms);
    }

    public void testCreateKeyManagers() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        KeyManager[] kms = kmp.createKeyManagers();
        this.validateKeyManagers(kms);
    }

    public void testExplicitAlgorithm() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        kmp.setAlgorithm(KeyManagerFactory.getDefaultAlgorithm());
        KeyManager[] kms = kmp.createKeyManagers();
        this.validateKeyManagers(kms);
    }

    public void testExplicitProvider() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        kmp.setProvider(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()).getProvider().getName());
        KeyManager[] kms = kmp.createKeyManagers();
        this.validateKeyManagers(kms);
    }

    public void testInvalidPassword() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        kmp.setKeyPassword("");
        try {
            kmp.createKeyManagers();
            KeyManagersParametersTest.fail();
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            // empty catch block
        }
    }

    public void testInvalidExplicitAlgorithm() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        kmp.setAlgorithm("dsfsdfsdfdsfdsF");
        try {
            kmp.createKeyManagers();
            KeyManagersParametersTest.fail();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public void testInvalidExplicitProvider() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        kmp.setProvider("dsfsdfsdfdsfdsF");
        try {
            kmp.createKeyManagers();
            KeyManagersParametersTest.fail();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
    }

    public void testAliasedKeyManager() throws Exception {
        KeyManagersParameters kmp = this.createMinimalKeyManagersParameters();
        KeyManager[] kms = kmp.createKeyManagers();
        KeyManagersParametersTest.assertEquals((int)1, (int)kms.length);
        KeyManagersParametersTest.assertTrue((boolean)(kms[0] instanceof X509KeyManager));
        kms[0] = new AliasedX509ExtendedKeyManager("server", (X509KeyManager)kms[0]);
        AliasedX509ExtendedKeyManager km = (AliasedX509ExtendedKeyManager)kms[0];
        KeyManagersParametersTest.assertNotNull((Object)km.getPrivateKey("server"));
    }

    protected void validateKeyManagers(KeyManager[] kms) {
        KeyManagersParametersTest.assertEquals((int)1, (int)kms.length);
        KeyManagersParametersTest.assertTrue((boolean)(kms[0] instanceof X509KeyManager));
        X509KeyManager km = (X509KeyManager)kms[0];
        KeyManagersParametersTest.assertNotNull((Object)km.getPrivateKey("server"));
    }
}

