/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.view;

import java.io.File;
import javax.xml.bind.JAXBContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.view.ModelFileGenerator;

public class ModelFileGeneratorTest
extends ContextTestSupport {
    protected String outputDirectory = "target/site/model";

    @Override
    protected void setUp() throws Exception {
        ModelFileGeneratorTest.deleteDirectory(this.outputDirectory);
        super.setUp();
    }

    public void testGenerateModel() throws Exception {
        try {
            ModelFileGenerator generator = new ModelFileGenerator(JAXBContext.newInstance((String)"org.apache.camel.model"));
            generator.marshalRoutesUsingJaxb(this.outputDirectory + "/route.xml", this.context.getRouteDefinitions());
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().startsWith("Not supported")) {
                return;
            }
            throw e;
        }
        File out = new File(this.outputDirectory + "/route.xml");
        ModelFileGeneratorTest.assertTrue((String)"File should have been generated", (boolean)out.exists());
        String content = (String)this.context.getTypeConverter().convertTo(String.class, (Object)out);
        ModelFileGeneratorTest.assertTrue((String)"Should contain a route", (boolean)content.contains("<route"));
        ModelFileGeneratorTest.assertTrue((String)"Should contain a route", (boolean)content.contains("</route>"));
        ModelFileGeneratorTest.assertTrue((String)"Should contain a route", (boolean)content.contains("direct:start"));
        ModelFileGeneratorTest.assertTrue((String)"Should contain a route", (boolean)content.contains("mock:result"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

