/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.api.management.mbean;

import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;

public interface ManagedAggregateProcessorMBean
extends ManagedProcessorMBean {
    @ManagedAttribute(description="Correlation Expression")
    public String getCorrelationExpression();

    @ManagedAttribute(description="Completion timeout in millis")
    public long getCompletionTimeout();

    @ManagedAttribute(description="Completion timeout expression")
    public String getCompletionTimeoutExpression();

    @ManagedAttribute(description="Completion interval in millis")
    public long getCompletionInterval();

    @ManagedAttribute(description="Completion size")
    public int getCompletionSize();

    @ManagedAttribute(description="Completion size expression")
    public String getCompletionSizeExpression();

    @ManagedAttribute(description="Complete from batch consumers")
    public boolean isCompletionFromBatchConsumer();

    @ManagedAttribute(description="Ignore invalid correlation keys")
    public boolean isIgnoreInvalidCorrelationKeys();

    @ManagedAttribute(description="Whether to close the correlation group on completion")
    public Integer getCloseCorrelationKeyOnCompletion();

    @ManagedAttribute(description="Parallel mode")
    public boolean isParallelProcessing();

    @ManagedAttribute(description="Optimistic locking")
    public boolean isOptimisticLocking();

    @ManagedAttribute(description="Whether or not to eager check for completion when a new incoming Exchange has been received")
    public boolean isEagerCheckCompletion();

    @ManagedAttribute(description="A Predicate to indicate when an aggregated exchange is complete")
    public String getCompletionPredicate();

    @ManagedAttribute(description="Whether or not exchanges which complete due to a timeout should be discarded")
    public boolean isDiscardOnCompletionTimeout();

    @ManagedAttribute(description="Indicates to complete all current aggregated exchanges when the context is stopped")
    public boolean isForceCompletionOnStop();

    @ManagedAttribute(description="Number of completed exchanges which are currently in-flight")
    public int getInProgressCompleteExchanges();

    @ManagedOperation(description="Number of groups currently in the aggregation repository")
    public int aggregationRepositoryGroups();

    @ManagedOperation(description="To force completing a specific group by its key")
    public int forceCompletionOfGroup(String var1);

    @ManagedOperation(description="To force complete of all groups")
    public int forceCompletionOfAllGroups();

    @ManagedAttribute(description="Total number of exchanges arrived into the aggregator")
    public long getTotalIn();

    @ManagedAttribute(description="Total number of exchanges completed and outgoing from the aggregator")
    public long getTotalCompleted();

    @ManagedAttribute(description="Total number of exchanged completed by completion size trigger")
    public long getCompletedBySize();

    @ManagedAttribute(description="Total number of exchanged completed by completion aggregation strategy trigger")
    public long getCompletedByStrategy();

    @ManagedAttribute(description="Total number of exchanged completed by completion interval (timeout) trigger")
    public long getCompletedByInterval();

    @ManagedAttribute(description="Total number of exchanged completed by completion timeout trigger")
    public long getCompletedByTimeout();

    @ManagedAttribute(description="Total number of exchanged completed by completion predicate trigger")
    public long getCompletedByPredicate();

    @ManagedAttribute(description="Total number of exchanged completed by completion batch consumer trigger")
    public long getCompletedByBatchConsumer();

    @ManagedAttribute(description="Total number of exchanged completed by completion force trigger")
    public long getCompletedByForce();

    @ManagedOperation(description=" Reset the statistics counters")
    public void resetStatistics();

    @Override
    @ManagedAttribute(description="Sets whether statistics is enabled")
    public boolean isStatisticsEnabled();

    @Override
    @ManagedAttribute(description="Sets whether statistics is enabled")
    public void setStatisticsEnabled(boolean var1);
}

