/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.strategy.FileChangedExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.FileIdempotentRepositoryReadLockStrategy;
import org.apache.camel.component.file.strategy.FileLockExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.FileRenameExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.GenericFileDeleteProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileExpressionRenamer;
import org.apache.camel.component.file.strategy.GenericFileRenameProcessStrategy;
import org.apache.camel.component.file.strategy.MarkerFileExclusiveReadLockStrategy;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;

public final class FileProcessStrategyFactory {
    private FileProcessStrategyFactory() {
    }

    public static GenericFileProcessStrategy<File> createGenericFileProcessStrategy(CamelContext context, Map<String, Object> params) {
        boolean isMove;
        Expression moveExpression = (Expression)params.get("move");
        Expression moveFailedExpression = (Expression)params.get("moveFailed");
        Expression preMoveExpression = (Expression)params.get("preMove");
        boolean isNoop = params.get("noop") != null;
        boolean isDelete = params.get("delete") != null;
        boolean bl = isMove = moveExpression != null || preMoveExpression != null || moveFailedExpression != null;
        if (isDelete) {
            GenericFileExpressionRenamer renamer;
            GenericFileDeleteProcessStrategy<File> strategy = new GenericFileDeleteProcessStrategy<File>();
            strategy.setExclusiveReadLockStrategy(FileProcessStrategyFactory.getExclusiveReadLockStrategy(params));
            if (preMoveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(preMoveExpression);
                strategy.setBeginRenamer(renamer);
            }
            if (moveFailedExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveFailedExpression);
                strategy.setFailureRenamer(renamer);
            }
            return strategy;
        }
        if (isMove || isNoop) {
            GenericFileExpressionRenamer renamer;
            GenericFileRenameProcessStrategy<File> strategy = new GenericFileRenameProcessStrategy<File>();
            strategy.setExclusiveReadLockStrategy(FileProcessStrategyFactory.getExclusiveReadLockStrategy(params));
            if (!isNoop) {
                if (moveExpression != null) {
                    renamer = new GenericFileExpressionRenamer();
                    renamer.setExpression(moveExpression);
                    strategy.setCommitRenamer(renamer);
                } else {
                    strategy.setCommitRenamer(FileProcessStrategyFactory.getDefaultCommitRenamer(context));
                }
            }
            if (preMoveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(preMoveExpression);
                strategy.setBeginRenamer(renamer);
            }
            if (moveFailedExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveFailedExpression);
                strategy.setFailureRenamer(renamer);
            }
            return strategy;
        }
        GenericFileRenameProcessStrategy<File> strategy = new GenericFileRenameProcessStrategy<File>();
        strategy.setExclusiveReadLockStrategy(FileProcessStrategyFactory.getExclusiveReadLockStrategy(params));
        strategy.setCommitRenamer(FileProcessStrategyFactory.getDefaultCommitRenamer(context));
        return strategy;
    }

    private static GenericFileExpressionRenamer<File> getDefaultCommitRenamer(CamelContext context) {
        Language language = context.resolveLanguage("file");
        Expression expression = language.createExpression("${file:parent}/.camel/${file:onlyname}");
        return new GenericFileExpressionRenamer<File>(expression);
    }

    private static GenericFileExclusiveReadLockStrategy<File> getExclusiveReadLockStrategy(Map<String, Object> params) {
        GenericFileExclusiveReadLockStrategy<File> strategy = (GenericFileExclusiveReadLockStrategy<File>)params.get("exclusiveReadLockStrategy");
        if (strategy != null) {
            return strategy;
        }
        String readLock = (String)params.get("readLock");
        if (ObjectHelper.isNotEmpty(readLock)) {
            GenericFileExclusiveReadLockStrategy<File> readLockStrategy;
            if ("none".equals(readLock) || "false".equals(readLock)) {
                return null;
            }
            if ("markerFile".equals(readLock)) {
                return new MarkerFileExclusiveReadLockStrategy();
            }
            if ("fileLock".equals(readLock)) {
                strategy = new FileLockExclusiveReadLockStrategy();
            } else if ("rename".equals(readLock)) {
                strategy = new FileRenameExclusiveReadLockStrategy();
            } else if ("changed".equals(readLock)) {
                Long minAge;
                readLockStrategy = new FileChangedExclusiveReadLockStrategy();
                Long minLength = (Long)params.get("readLockMinLength");
                if (minLength != null) {
                    ((FileChangedExclusiveReadLockStrategy)readLockStrategy).setMinLength(minLength);
                }
                if (null != (minAge = (Long)params.get("readLockMinAge"))) {
                    ((FileChangedExclusiveReadLockStrategy)readLockStrategy).setMinAge(minAge);
                }
                strategy = readLockStrategy;
            } else if ("idempotent".equals(readLock)) {
                IdempotentRepository repo;
                Boolean readLockRemoveOnCommit;
                readLockStrategy = new FileIdempotentRepositoryReadLockStrategy();
                Boolean readLockRemoveOnRollback = (Boolean)params.get("readLockRemoveOnRollback");
                if (readLockRemoveOnRollback != null) {
                    ((FileIdempotentRepositoryReadLockStrategy)readLockStrategy).setRemoveOnRollback(readLockRemoveOnRollback);
                }
                if ((readLockRemoveOnCommit = (Boolean)params.get("readLockRemoveOnCommit")) != null) {
                    ((FileIdempotentRepositoryReadLockStrategy)readLockStrategy).setRemoveOnCommit(readLockRemoveOnCommit);
                }
                if ((repo = (IdempotentRepository)params.get("readLockIdempotentRepository")) != null) {
                    ((FileIdempotentRepositoryReadLockStrategy)readLockStrategy).setIdempotentRepository(repo);
                }
                strategy = readLockStrategy;
            }
            if (strategy != null) {
                Boolean readLockMarkerFile;
                LoggingLevel readLockLoggingLevel;
                Long checkInterval;
                Long timeout = (Long)params.get("readLockTimeout");
                if (timeout != null) {
                    strategy.setTimeout(timeout);
                }
                if ((checkInterval = (Long)params.get("readLockCheckInterval")) != null) {
                    strategy.setCheckInterval(checkInterval);
                }
                if ((readLockLoggingLevel = (LoggingLevel)((Object)params.get("readLockLoggingLevel"))) != null) {
                    strategy.setReadLockLoggingLevel(readLockLoggingLevel);
                }
                if ((readLockMarkerFile = (Boolean)params.get("readLockMarkerFile")) != null) {
                    strategy.setMarkerFiler(readLockMarkerFile);
                }
            }
        }
        return strategy;
    }
}

