/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;

public class SetHeaderProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable,
IdAware {
    private String id;
    private final String headerName;
    private final Expression expression;

    public SetHeaderProcessor(String headerName, Expression expression) {
        this.headerName = headerName;
        this.expression = expression;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Object newHeader = this.expression.evaluate(exchange, Object.class);
            boolean out = exchange.hasOut();
            Message old = out ? exchange.getOut() : exchange.getIn();
            old.setHeader(this.headerName, newHeader);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "SetHeader(" + this.headerName + ", " + this.expression + ")";
    }

    @Override
    public String getTraceLabel() {
        return "setHeader[" + this.headerName + ", " + this.expression + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

