/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;

public class ThrowExceptionProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable,
IdAware {
    private String id;
    private final Exception exception;

    public ThrowExceptionProcessor(Exception exception) {
        ObjectHelper.notNull(exception, "exception", this);
        this.exception = exception;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        exchange.setException(this.exception);
        callback.done(true);
        return true;
    }

    @Override
    public String getTraceLabel() {
        return "throwException[" + this.exception.getClass().getSimpleName() + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Exception getException() {
        return this.exception;
    }

    public String toString() {
        return "ThrowException";
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

