/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.Source;
import org.apache.camel.BytesSource;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.StreamCache;
import org.apache.camel.StringSource;
import org.apache.camel.WrappedFile;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public final class MessageHelper {
    private static final String MESSAGE_HISTORY_HEADER = "%-20s %-20s %-80s %-12s";
    private static final String MESSAGE_HISTORY_OUTPUT = "[%-18.18s] [%-18.18s] [%-78.78s] [%10.10s]";

    private MessageHelper() {
    }

    public static String extractBodyAsString(Message message) {
        Object answer;
        if (message == null) {
            return null;
        }
        Object body = message.getBody();
        if (body instanceof String) {
            return (String)body;
        }
        StreamCache newBody = message.getBody(StreamCache.class);
        if (newBody != null) {
            message.setBody(newBody);
        }
        if ((answer = message.getBody(String.class)) == null) {
            answer = message.getBody();
        }
        if (newBody != null) {
            newBody.reset();
        }
        return answer != null ? answer.toString() : null;
    }

    public static String getBodyTypeName(Message message) {
        if (message == null) {
            return null;
        }
        String answer = ObjectHelper.classCanonicalName(message.getBody());
        if (answer != null && answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        return answer;
    }

    public static void resetStreamCache(Message message) {
        if (message == null) {
            return;
        }
        Object body = message.getBody();
        if (body != null && body instanceof StreamCache) {
            ((StreamCache)body).reset();
        }
    }

    public static String getContentType(Message message) {
        return message.getHeader("Content-Type", String.class);
    }

    public static String getContentEncoding(Message message) {
        return message.getHeader("Content-Encoding", String.class);
    }

    public static String extractBodyForLogging(Message message) {
        return MessageHelper.extractBodyForLogging(message, "Message: ");
    }

    public static String extractValueForLogging(Object value, Message message) {
        String property;
        String property2;
        boolean streams = false;
        if (message.getExchange() != null && (property2 = message.getExchange().getContext().getProperty("CamelLogDebugStreams")) != null) {
            streams = message.getExchange().getContext().getTypeConverter().convertTo(Boolean.class, message.getExchange(), property2);
        }
        int maxChars = 1000;
        if (message.getExchange() != null && (property = message.getExchange().getContext().getProperty("CamelLogDebugBodyMaxChars")) != null) {
            maxChars = message.getExchange().getContext().getTypeConverter().convertTo(Integer.class, property);
        }
        return MessageHelper.extractValueForLogging(value, message, "", streams, false, maxChars);
    }

    public static String extractBodyForLogging(Message message, String prepend) {
        String property;
        String property2;
        boolean streams = false;
        if (message.getExchange() != null && (property2 = message.getExchange().getContext().getProperty("CamelLogDebugStreams")) != null) {
            streams = message.getExchange().getContext().getTypeConverter().convertTo(Boolean.class, message.getExchange(), property2);
        }
        int maxChars = 1000;
        if (message.getExchange() != null && (property = message.getExchange().getContext().getProperty("CamelLogDebugBodyMaxChars")) != null) {
            maxChars = message.getExchange().getContext().getTypeConverter().convertTo(Integer.class, property);
        }
        return MessageHelper.extractBodyForLogging(message, prepend, streams, false, maxChars);
    }

    public static String extractBodyForLogging(Message message, String prepend, boolean allowStreams, boolean allowFiles, int maxChars) {
        return MessageHelper.extractValueForLogging(message.getBody(), message, prepend, allowStreams, allowFiles, maxChars);
    }

    public static String extractValueForLogging(Object obj, Message message, String prepend, boolean allowStreams, boolean allowFiles, int maxChars) {
        if (maxChars < 0) {
            return prepend + "[Body is not logged]";
        }
        if (obj == null) {
            return prepend + "[Body is null]";
        }
        if (!allowStreams) {
            if (obj instanceof Source && !(obj instanceof StringSource) && !(obj instanceof BytesSource)) {
                return prepend + "[Body is instance of java.xml.transform.Source]";
            }
            if (obj instanceof StreamCache) {
                return prepend + "[Body is instance of org.apache.camel.StreamCache]";
            }
            if (obj instanceof InputStream) {
                return prepend + "[Body is instance of java.io.InputStream]";
            }
            if (obj instanceof OutputStream) {
                return prepend + "[Body is instance of java.io.OutputStream]";
            }
            if (obj instanceof Reader) {
                return prepend + "[Body is instance of java.io.Reader]";
            }
            if (obj instanceof Writer) {
                return prepend + "[Body is instance of java.io.Writer]";
            }
            if ((obj instanceof WrappedFile || obj instanceof File) && !allowFiles) {
                return prepend + "[Body is file based: " + obj + "]";
            }
        }
        if (!allowFiles && (obj instanceof WrappedFile || obj instanceof File)) {
            return prepend + "[Body is file based: " + obj + "]";
        }
        StreamCache cache = null;
        InputStream is = null;
        if (obj instanceof StreamCache) {
            cache = (StreamCache)obj;
            is = null;
        } else if (obj instanceof InputStream) {
            cache = null;
            is = (InputStream)obj;
        }
        String body = null;
        if (message.getExchange() != null) {
            try {
                body = message.getExchange().getContext().getTypeConverter().tryConvertTo(String.class, message.getExchange(), obj);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (body == null) {
            try {
                body = obj.toString();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (cache != null) {
            cache.reset();
        } else if (is != null && is.markSupported()) {
            try {
                is.reset();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (body == null) {
            return prepend + "[Body is null]";
        }
        if (maxChars > 0 && body.length() > maxChars) {
            body = body.substring(0, maxChars) + "... [Body clipped after " + maxChars + " chars, total length is " + body.length() + "]";
        }
        return prepend + body;
    }

    public static String dumpAsXml(Message message) {
        return MessageHelper.dumpAsXml(message, true);
    }

    public static String dumpAsXml(Message message, boolean includeBody) {
        return MessageHelper.dumpAsXml(message, includeBody, 0);
    }

    public static String dumpAsXml(Message message, boolean includeBody, int indent) {
        return MessageHelper.dumpAsXml(message, includeBody, indent, false, true, 131072);
    }

    public static String dumpAsXml(Message message, boolean includeBody, int indent, boolean allowStreams, boolean allowFiles, int maxChars) {
        StringBuilder sb = new StringBuilder();
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            prefix.append(" ");
        }
        sb.append((CharSequence)prefix);
        sb.append("<message exchangeId=\"").append(message.getExchange().getExchangeId()).append("\">\n");
        if (message.hasHeaders()) {
            sb.append((CharSequence)prefix);
            sb.append("  <headers>\n");
            TreeMap<String, Object> headers = new TreeMap<String, Object>(message.getHeaders());
            for (Map.Entry entry : headers.entrySet()) {
                Object value = entry.getValue();
                String type = ObjectHelper.classCanonicalName(value);
                sb.append((CharSequence)prefix);
                sb.append("    <header key=\"").append((String)entry.getKey()).append("\"");
                if (type != null) {
                    sb.append(" type=\"").append(type).append("\"");
                }
                sb.append(">");
                if (value != null) {
                    try {
                        String xml = message.getExchange().getContext().getTypeConverter().tryConvertTo(String.class, message.getExchange(), value);
                        if (xml != null) {
                            sb.append(StringHelper.xmlEncode(xml));
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                sb.append("</header>\n");
            }
            sb.append((CharSequence)prefix);
            sb.append("  </headers>\n");
        }
        if (includeBody) {
            sb.append((CharSequence)prefix);
            sb.append("  <body");
            String type = ObjectHelper.classCanonicalName(message.getBody());
            if (type != null) {
                sb.append(" type=\"").append(type).append("\"");
            }
            sb.append(">");
            String xml = MessageHelper.extractBodyForLogging(message, "", allowStreams, allowFiles, maxChars);
            if (xml != null) {
                sb.append(StringHelper.xmlEncode(xml));
            }
            sb.append("</body>\n");
        }
        sb.append((CharSequence)prefix);
        sb.append("</message>");
        return sb.toString();
    }

    public static void copyHeaders(Message source, Message target, boolean override) {
        MessageHelper.copyHeaders(source, target, null, override);
    }

    public static void copyHeaders(Message source, Message target, HeaderFilterStrategy strategy, boolean override) {
        if (!source.hasHeaders()) {
            return;
        }
        for (Map.Entry<String, Object> entry : source.getHeaders().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (target.getHeader(key) != null && !override) continue;
            if (strategy == null) {
                target.setHeader(key, value);
                continue;
            }
            if (strategy.applyFilterToCamelHeaders(key, value, target.getExchange())) continue;
            target.setHeader(key, value);
        }
    }

    public static String dumpMessageHistoryStacktrace(Exchange exchange, ExchangeFormatter exchangeFormatter, boolean logStackTrace) {
        try {
            return MessageHelper.doDumpMessageHistoryStacktrace(exchange, exchangeFormatter, logStackTrace);
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String doDumpMessageHistoryStacktrace(Exchange exchange, ExchangeFormatter exchangeFormatter, boolean logStackTrace) {
        String routeId;
        List list = exchange.getProperty("CamelMessageHistory", List.class);
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("Message History\n");
        sb.append("---------------------------------------------------------------------------------------------------------------------------------------\n");
        sb.append(String.format(MESSAGE_HISTORY_HEADER, "RouteId", "ProcessorId", "Processor", "Elapsed (ms)"));
        sb.append("\n");
        String id = routeId = exchange.getFromRouteId();
        String label = "";
        if (exchange.getFromEndpoint() != null) {
            label = URISupport.sanitizeUri(exchange.getFromEndpoint().getEndpointUri());
        }
        long elapsed = 0L;
        Date created = exchange.getProperty("CamelCreatedTimestamp", Date.class);
        if (created != null) {
            elapsed = new StopWatch(created).stop();
        }
        sb.append(String.format(MESSAGE_HISTORY_OUTPUT, routeId, id, label, elapsed));
        sb.append("\n");
        for (MessageHistory history : list) {
            routeId = history.getRouteId() != null ? history.getRouteId() : "";
            id = history.getNode().getId();
            label = URISupport.sanitizeUri(history.getNode().getLabel());
            elapsed = history.getElapsed();
            sb.append(String.format(MESSAGE_HISTORY_OUTPUT, routeId, id, label, elapsed));
            sb.append("\n");
        }
        if (exchangeFormatter != null) {
            sb.append("\nExchange\n");
            sb.append("---------------------------------------------------------------------------------------------------------------------------------------\n");
            sb.append(exchangeFormatter.format(exchange));
            sb.append("\n");
        }
        if (logStackTrace) {
            sb.append("\nStacktrace\n");
            sb.append("---------------------------------------------------------------------------------------------------------------------------------------");
        }
        return sb.toString();
    }
}

