/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.api.management.mbean;

import org.apache.camel.api.management.ManagedAttribute;

public interface ManagedErrorHandlerMBean {
    @ManagedAttribute(description="Camel ID")
    public String getCamelId();

    @ManagedAttribute(description="Camel ManagementName")
    public String getCamelManagementName();

    @ManagedAttribute(description="Does the error handler support redelivery")
    public boolean isSupportRedelivery();

    @ManagedAttribute(description="Is this error handler a dead letter channel")
    public boolean isDeadLetterChannel();

    @ManagedAttribute(description="When a message is moved to dead letter channel is it the original message or recent message")
    public boolean isDeadLetterUseOriginalMessage();

    @ManagedAttribute(description="Does this error handler handle new exceptions which may occur during error handling")
    public boolean isDeadLetterHandleNewException();

    @ManagedAttribute(description="Does this error handler support transactions")
    public boolean isSupportTransactions();

    @ManagedAttribute(description="Endpoint Uri for the dead letter channel where dead message is move to", mask=true)
    public String getDeadLetterChannelEndpointUri();

    @ManagedAttribute(description="RedeliveryPolicy for maximum redeliveries")
    public Integer getMaximumRedeliveries();

    @ManagedAttribute(description="RedeliveryPolicy for maximum redeliveries")
    public void setMaximumRedeliveries(Integer var1);

    @ManagedAttribute(description="RedeliveryPolicy for maximum redelivery delay")
    public Long getMaximumRedeliveryDelay();

    @ManagedAttribute(description="RedeliveryPolicy for maximum redelivery delay")
    public void setMaximumRedeliveryDelay(Long var1);

    @ManagedAttribute(description="RedeliveryPolicy for redelivery delay")
    public Long getRedeliveryDelay();

    @ManagedAttribute(description="RedeliveryPolicy for redelivery delay")
    public void setRedeliveryDelay(Long var1);

    @ManagedAttribute(description="RedeliveryPolicy for backoff multiplier")
    public Double getBackOffMultiplier();

    @ManagedAttribute(description="RedeliveryPolicy for backoff multiplier")
    public void setBackOffMultiplier(Double var1);

    @ManagedAttribute(description="RedeliveryPolicy for collision avoidance factor")
    public Double getCollisionAvoidanceFactor();

    @ManagedAttribute(description="RedeliveryPolicy for collision avoidance factor")
    public void setCollisionAvoidanceFactor(Double var1);

    @ManagedAttribute(description="RedeliveryPolicy for collision avoidance percent")
    public Double getCollisionAvoidancePercent();

    @ManagedAttribute(description="RedeliveryPolicy for collision avoidance percent")
    public void setCollisionAvoidancePercent(Double var1);

    @ManagedAttribute(description="RedeliveryPolicy for delay pattern")
    public String getDelayPattern();

    @ManagedAttribute(description="RedeliveryPolicy for delay pattern")
    public void setDelayPattern(String var1);

    @ManagedAttribute(description="RedeliveryPolicy for logging level when retries exhausted")
    public String getRetriesExhaustedLogLevel();

    @ManagedAttribute(description="RedeliveryPolicy for logging level when retries exhausted")
    public void setRetriesExhaustedLogLevel(String var1);

    @ManagedAttribute(description="RedeliveryPolicy for logging level when attempting retry")
    public String getRetryAttemptedLogLevel();

    @ManagedAttribute(description="RedeliveryPolicy for logging level when attempting retry")
    public void setRetryAttemptedLogLevel(String var1);

    @ManagedAttribute(description="RedeliveryPolicy for logging stack traces")
    public Boolean getLogStackTrace();

    @ManagedAttribute(description="RedeliveryPolicy for logging stack traces")
    public void setLogStackTrace(Boolean var1);

    @ManagedAttribute(description="RedeliveryPolicy for logging redelivery stack traces")
    public Boolean getLogRetryStackTrace();

    @ManagedAttribute(description="RedeliveryPolicy for logging redelivery stack traces")
    public void setLogRetryStackTrace(Boolean var1);

    @ManagedAttribute(description="RedeliveryPolicy for logging handled exceptions")
    public Boolean getLogHandled();

    @ManagedAttribute(description="RedeliveryPolicy for logging handled exceptions")
    public void setLogHandled(Boolean var1);

    @ManagedAttribute(description="RedeliveryPolicy for logging new exceptions")
    public Boolean getLogNewException();

    @ManagedAttribute(description="RedeliveryPolicy for logging new exceptions")
    public void setLogNewException(Boolean var1);

    @ManagedAttribute(description="RedeliveryPolicy for logging exhausted with message history")
    public Boolean getLogExhaustedMessageHistory();

    @ManagedAttribute(description="RedeliveryPolicy for logging exhausted with message history")
    public void setLogExhaustedMessageHistory(Boolean var1);

    @ManagedAttribute(description="RedeliveryPolicy for logging handled and continued exceptions")
    public Boolean getLogContinued();

    @ManagedAttribute(description="RedeliveryPolicy for logging handled and continued exceptions")
    public void setLogContinued(Boolean var1);

    @ManagedAttribute(description="RedeliveryPolicy for logging exhausted exceptions")
    public Boolean getLogExhausted();

    @ManagedAttribute(description="RedeliveryPolicy for logging exhausted exceptions")
    public void setLogExhausted(Boolean var1);

    @ManagedAttribute(description="RedeliveryPolicy for using collision avoidance")
    public Boolean getUseCollisionAvoidance();

    @ManagedAttribute(description="RedeliveryPolicy for using collision avoidance")
    public void setUseCollisionAvoidance(Boolean var1);

    @ManagedAttribute(description="RedeliveryPolicy for using exponential backoff")
    public Boolean getUseExponentialBackOff();

    @ManagedAttribute(description="RedeliveryPolicy for using exponential backoff")
    public void setUseExponentialBackOff(Boolean var1);

    @ManagedAttribute(description="RedeliveryPolicy for allow redelivery while stopping")
    public Boolean getAllowRedeliveryWhileStopping();

    @ManagedAttribute(description="RedeliveryPolicy for allow redelivery while stopping")
    public void setAllowRedeliveryWhileStopping(Boolean var1);
}

