/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jsse;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.LinkedList;
import org.apache.camel.util.jsse.JsseParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreParameters
extends JsseParameters {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreParameters.class);
    protected String type;
    protected String password;
    protected String provider;
    protected String resource;

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String value) {
        this.provider = value;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String value) {
        this.resource = value;
    }

    public KeyStore createKeyStore() throws GeneralSecurityException, IOException {
        LOG.trace("Creating KeyStore instance from KeyStoreParameters [{}].", (Object)this);
        String ksType = this.parsePropertyValue(this.type);
        if (ksType == null) {
            ksType = KeyStore.getDefaultType();
        }
        char[] ksPassword = null;
        if (this.password != null) {
            ksPassword = this.parsePropertyValue(this.password).toCharArray();
        }
        KeyStore ks = this.provider == null ? KeyStore.getInstance(ksType) : KeyStore.getInstance(ksType, this.parsePropertyValue(this.provider));
        if (this.resource == null) {
            ks.load(null, ksPassword);
        } else {
            InputStream is = this.resolveResource(this.parsePropertyValue(this.resource));
            ks.load(is, ksPassword);
        }
        if (LOG.isDebugEnabled()) {
            LinkedList<String> aliases = new LinkedList<String>();
            Enumeration<String> aliasEnum = ks.aliases();
            while (aliasEnum.hasMoreElements()) {
                aliases.add(aliasEnum.nextElement());
            }
            LOG.debug("KeyStore [{}], initialized from [{}], is using provider [{}], has type [{}], and contains aliases {}.", new Object[]{ks, this, ks.getProvider(), ks.getType(), aliases});
        }
        return ks;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("KeyStoreParameters [type=");
        builder.append(this.type);
        builder.append(", password=");
        builder.append("********");
        builder.append(", provider=");
        builder.append(this.provider);
        builder.append(", resource=");
        builder.append(this.resource);
        builder.append(", getContext()=");
        builder.append(this.getCamelContext());
        builder.append("]");
        return builder.toString();
    }
}

