/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Traceable;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class UnmarshalProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable,
CamelContextAware,
IdAware {
    private String id;
    private CamelContext camelContext;
    private final DataFormat dataFormat;

    public UnmarshalProcessor(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        ObjectHelper.notNull(this.dataFormat, "dataFormat");
        InputStream stream = null;
        Object result = null;
        try {
            stream = exchange.getIn().getMandatoryBody(InputStream.class);
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            result = this.dataFormat.unmarshal(exchange, stream);
            if (result instanceof Exchange) {
                if (result != exchange) {
                    throw new RuntimeCamelException("The returned exchange " + result + " is not the same as " + exchange + " provided to the DataFormat");
                }
            } else if (result instanceof Message) {
                exchange.setOut((Message)result);
            } else {
                out.setBody(result);
            }
        }
        catch (Throwable e) {
            exchange.setOut(null);
            exchange.setException(e);
        }
        finally {
            if (!(result instanceof Iterator)) {
                IOHelper.close((Closeable)stream, "input stream");
            }
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "Unmarshal[" + this.dataFormat + "]";
    }

    @Override
    public String getTraceLabel() {
        return "unmarshal[" + this.dataFormat + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.dataFormat instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.dataFormat)).setCamelContext(this.camelContext);
        }
        ServiceHelper.startService(this.dataFormat);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.dataFormat);
    }
}

