/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.loadbalancer;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.FailOverLoadBalancer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="configuration,loadbalance")
@XmlRootElement(name="failover")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FailoverLoadBalancerDefinition
extends LoadBalancerDefinition {
    @XmlTransient
    private List<Class<?>> exceptionTypes = new ArrayList();
    @XmlElement(name="exception")
    private List<String> exceptions = new ArrayList<String>();
    @XmlAttribute
    private Boolean roundRobin;
    @XmlAttribute
    private Boolean sticky;
    @XmlAttribute
    @Metadata(defaultValue="-1")
    private Integer maximumFailoverAttempts;

    @Override
    protected LoadBalancer createLoadBalancer(RouteContext routeContext) {
        ArrayList classes = new ArrayList();
        if (!this.exceptionTypes.isEmpty()) {
            classes.addAll(this.exceptionTypes);
        } else if (!this.exceptions.isEmpty()) {
            for (String name : this.exceptions) {
                Class<?> type = routeContext.getCamelContext().getClassResolver().resolveClass(name);
                if (type == null) {
                    throw new IllegalArgumentException("Cannot find class: " + name + " in the classpath");
                }
                if (!ObjectHelper.isAssignableFrom(Throwable.class, type)) {
                    throw new IllegalArgumentException("Class is not an instance of Throwable: " + type);
                }
                classes.add(type);
            }
        }
        FailOverLoadBalancer answer = classes.isEmpty() ? new FailOverLoadBalancer() : new FailOverLoadBalancer(classes);
        if (this.getMaximumFailoverAttempts() != null) {
            answer.setMaximumFailoverAttempts(this.getMaximumFailoverAttempts());
        }
        if (this.roundRobin != null) {
            answer.setRoundRobin(this.roundRobin);
        }
        if (this.sticky != null) {
            answer.setSticky(this.sticky);
        }
        return answer;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public List<Class<?>> getExceptionTypes() {
        return this.exceptionTypes;
    }

    public void setExceptionTypes(List<Class<?>> exceptionTypes) {
        this.exceptionTypes = exceptionTypes;
    }

    public Boolean getRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(Boolean roundRobin) {
        this.roundRobin = roundRobin;
    }

    public Boolean getSticky() {
        return this.sticky;
    }

    public void setSticky(Boolean sticky) {
        this.sticky = sticky;
    }

    public Integer getMaximumFailoverAttempts() {
        return this.maximumFailoverAttempts;
    }

    public void setMaximumFailoverAttempts(Integer maximumFailoverAttempts) {
        this.maximumFailoverAttempts = maximumFailoverAttempts;
    }

    @Override
    public String toString() {
        return "FailoverLoadBalancer";
    }
}

