/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.Map;
import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.rest.RestApiComponent;
import org.apache.camel.component.rest.RestApiProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestApiProcessorFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(scheme="rest-api", title="REST API", syntax="rest-api:path/contextId", consumerOnly=true, label="core,rest", lenientProperties=true)
public class RestApiEndpoint
extends DefaultEndpoint {
    public static final String DEFAULT_API_COMPONENT_NAME = "swagger";
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/rest/";
    @UriPath
    @Metadata(required="true")
    private String path;
    @UriPath
    private String contextIdPattern;
    @UriParam
    private String componentName;
    @UriParam
    private String apiComponentName;
    private Map<String, Object> parameters;

    public RestApiEndpoint(String endpointUri, RestApiComponent component) {
        super(endpointUri, component);
        this.setExchangePattern(ExchangePattern.InOut);
    }

    @Override
    public RestApiComponent getComponent() {
        return (RestApiComponent)super.getComponent();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getContextIdPattern() {
        return this.contextIdPattern;
    }

    public void setContextIdPattern(String contextIdPattern) {
        this.contextIdPattern = contextIdPattern;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getApiComponentName() {
        return this.apiComponentName;
    }

    public void setApiComponentName(String apiComponentName) {
        this.apiComponentName = apiComponentName;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Producer createProducer() throws Exception {
        RestApiProcessorFactory factory = null;
        RestConfiguration config = this.getCamelContext().getRestConfiguration(this.componentName, true);
        Set<RestApiProcessorFactory> factories = this.getCamelContext().getRegistry().findByType(RestApiProcessorFactory.class);
        if (factories != null && factories.size() == 1) {
            factory = factories.iterator().next();
        }
        if (factory == null) {
            String name;
            String string = name = this.apiComponentName != null ? this.apiComponentName : config.getApiComponent();
            if (name == null) {
                name = DEFAULT_API_COMPONENT_NAME;
            }
            try {
                FactoryFinder finder = this.getCamelContext().getFactoryFinder(RESOURCE_PATH);
                Object instance = finder.newInstance(name);
                if (instance instanceof RestApiProcessorFactory) {
                    factory = (RestApiProcessorFactory)instance;
                }
            }
            catch (NoFactoryAvailableException finder) {
                // empty catch block
            }
        }
        if (factory != null) {
            String path;
            int num;
            String host = "";
            int port = 80;
            if (config.getHost() != null) {
                host = config.getHost();
            }
            if ((num = config.getPort()) > 0) {
                port = num;
            }
            if (ObjectHelper.isEmpty(host)) {
                if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                    host = "0.0.0.0";
                } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                    host = HostUtils.getLocalHostName();
                } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                    host = HostUtils.getLocalIp();
                }
                String targetHost = host + (port != 80 ? ":" + port : "");
                this.getParameters().put("host", targetHost);
            }
            if ((path = this.getPath()) != null && !path.startsWith("/")) {
                path = "/" + path;
            }
            boolean contextIdListing = config.isApiContextListing();
            Processor processor = factory.createApiProcessor(this.getCamelContext(), path, this.getContextIdPattern(), contextIdListing, config, this.getParameters());
            return new RestApiProducer(this, processor);
        }
        throw new IllegalStateException("Cannot find RestApiProcessorFactory in Registry or classpath (such as the camel-swagger-java component)");
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        Set<RestApiConsumerFactory> factories;
        RestApiConsumerFactory factory = null;
        String cname = null;
        if (this.getComponentName() != null) {
            Object comp = this.getCamelContext().getRegistry().lookupByName(this.getComponentName());
            if (comp != null && comp instanceof RestApiConsumerFactory) {
                factory = (RestApiConsumerFactory)comp;
            } else {
                comp = this.getCamelContext().getComponent(this.getComponentName());
                if (comp != null && comp instanceof RestApiConsumerFactory) {
                    factory = (RestApiConsumerFactory)comp;
                }
            }
            if (factory == null) {
                if (comp != null) {
                    throw new IllegalArgumentException("Component " + this.getComponentName() + " is not a RestApiConsumerFactory");
                }
                throw new NoSuchBeanException(this.getComponentName(), RestApiConsumerFactory.class.getName());
            }
            cname = this.getComponentName();
        }
        if (factory == null) {
            for (String name : this.getCamelContext().getComponentNames()) {
                Component comp = this.getCamelContext().getComponent(name);
                if (comp == null || !(comp instanceof RestApiConsumerFactory)) continue;
                factory = (RestApiConsumerFactory)((Object)comp);
                cname = name;
                break;
            }
        }
        if (factory == null && (factories = this.getCamelContext().getRegistry().findByType(RestApiConsumerFactory.class)) != null && factories.size() == 1) {
            factory = factories.iterator().next();
        }
        if (factory != null) {
            RestConfiguration config = this.getCamelContext().getRestConfiguration(cname, true);
            String path = this.getPath();
            if (path != null && !path.startsWith("/")) {
                path = "/" + path;
            }
            Consumer consumer = factory.createApiConsumer(this.getCamelContext(), processor, path, config, this.getParameters());
            this.configureConsumer(consumer);
            return consumer;
        }
        throw new IllegalStateException("Cannot find RestApiConsumerFactory in Registry or as a Component to use");
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean isLenientProperties() {
        return true;
    }
}

