/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.MessageHistory;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.StatefulService;
import org.apache.camel.StreamCache;
import org.apache.camel.api.management.PerformanceCounter;
import org.apache.camel.management.DelegatePerformanceCounter;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.processor.CamelInternalProcessorAdvice;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.interceptor.BacklogDebugger;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.processor.interceptor.DefaultBacklogTracerEventMessage;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.UnitOfWorkHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelInternalProcessor
extends DelegateAsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CamelInternalProcessor.class);
    private final List<CamelInternalProcessorAdvice> advices = new ArrayList<CamelInternalProcessorAdvice>();

    public CamelInternalProcessor() {
    }

    public CamelInternalProcessor(Processor processor) {
        super(processor);
    }

    public void addAdvice(CamelInternalProcessorAdvice advice) {
        this.advices.add(advice);
    }

    public <T> T getAdvice(Class<T> type) {
        for (CamelInternalProcessorAdvice task : this.advices) {
            if (!type.isInstance(task)) continue;
            return type.cast(task);
        }
        return null;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.processor == null || !this.continueProcessing(exchange)) {
            callback.done(true);
            return true;
        }
        ArrayList states = new ArrayList(this.advices.size());
        for (CamelInternalProcessorAdvice task : this.advices) {
            try {
                Object state = task.before(exchange);
                states.add(state);
            }
            catch (Throwable e) {
                exchange.setException(e);
                callback.done(true);
                return true;
            }
        }
        callback = new InternalCallback(states, exchange, callback);
        Object synchronous = exchange.removeProperty("CamelUnitOfWorkProcessSync");
        if (exchange.isTransacted() || synchronous != null) {
            if (LOG.isTraceEnabled()) {
                if (exchange.isTransacted()) {
                    LOG.trace("Transacted Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                } else {
                    LOG.trace("Synchronous UnitOfWork Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                }
            }
            try {
                this.processor.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
        UnitOfWork uow = exchange.getUnitOfWork();
        AsyncCallback async = callback;
        if (uow != null) {
            async = uow.beforeProcess(this.processor, exchange, callback);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing exchange for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        boolean sync = this.processor.process(exchange, async);
        if (uow != null) {
            uow.afterProcess(this.processor, exchange, callback, sync);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exchange processed and is continued routed {} for exchangeId: {} -> {}", new Object[]{sync ? "synchronously" : "asynchronously", exchange.getExchangeId(), exchange});
        }
        return sync;
    }

    @Override
    public String toString() {
        return this.processor != null ? this.processor.toString() : super.toString();
    }

    protected boolean continueProcessing(Exchange exchange) {
        boolean doStop;
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null && (doStop = exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop).booleanValue())) {
            LOG.debug("Exchange is marked to stop routing: {}", (Object)exchange);
            return false;
        }
        boolean forceShutdown = exchange.getContext().getShutdownStrategy().forceShutdown(this);
        if (forceShutdown) {
            String msg = "Run not allowed as ShutdownStrategy is forcing shutting down, will reject executing exchange: " + exchange;
            LOG.debug(msg);
            if (exchange.getException() == null) {
                exchange.setException(new RejectedExecutionException(msg));
            }
            return false;
        }
        return true;
    }

    public static class DelayerAdvice
    implements CamelInternalProcessorAdvice {
        private final long delay;

        public DelayerAdvice(long delay) {
            this.delay = delay;
        }

        public Object before(Exchange exchange) throws Exception {
            try {
                LOG.trace("Sleeping for: {} millis", (Object)this.delay);
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                LOG.debug("Sleep interrupted");
                Thread.currentThread().interrupt();
                throw e;
            }
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
        }
    }

    public static class StreamCachingAdvice
    implements CamelInternalProcessorAdvice<StreamCache> {
        private final StreamCachingStrategy strategy;

        public StreamCachingAdvice(StreamCachingStrategy strategy) {
            this.strategy = strategy;
        }

        @Override
        public StreamCache before(Exchange exchange) throws Exception {
            Object body = exchange.getIn().getBody();
            if (body == null) {
                return null;
            }
            if (body instanceof StreamCache) {
                StreamCache sc = (StreamCache)body;
                sc.reset();
                return sc;
            }
            StreamCache sc = this.strategy.cache(exchange);
            if (sc != null) {
                exchange.getIn().setBody(sc);
            }
            return sc;
        }

        @Override
        public void after(Exchange exchange, StreamCache sc) throws Exception {
            Object body = null;
            body = exchange.hasOut() ? exchange.getOut().getBody() : exchange.getIn().getBody();
            if (body != null && body instanceof StreamCache) {
                ((StreamCache)body).reset();
            }
        }
    }

    public static class MessageHistoryAdvice
    implements CamelInternalProcessorAdvice<MessageHistory> {
        private final MessageHistoryFactory factory;
        private final ProcessorDefinition<?> definition;
        private final String routeId;

        public MessageHistoryAdvice(MessageHistoryFactory factory, ProcessorDefinition<?> definition) {
            this.factory = factory;
            this.definition = definition;
            this.routeId = ProcessorDefinitionHelper.getRouteId(definition);
        }

        @Override
        public MessageHistory before(Exchange exchange) throws Exception {
            ArrayList<MessageHistory> list = exchange.getProperty("CamelMessageHistory", List.class);
            if (list == null) {
                list = new ArrayList<MessageHistory>();
                exchange.setProperty("CamelMessageHistory", list);
            }
            MessageHistory history = this.factory.newMessageHistory(this.routeId, this.definition, new Date());
            list.add(history);
            return history;
        }

        @Override
        public void after(Exchange exchange, MessageHistory history) throws Exception {
            if (history != null) {
                history.nodeProcessingDone();
            }
        }
    }

    public static class SubUnitOfWorkProcessorAdvice
    implements CamelInternalProcessorAdvice<UnitOfWork> {
        @Override
        public UnitOfWork before(Exchange exchange) throws Exception {
            exchange.getUnitOfWork().beginSubUnitOfWork(exchange);
            return exchange.getUnitOfWork();
        }

        @Override
        public void after(Exchange exchange, UnitOfWork unitOfWork) throws Exception {
            unitOfWork.endSubUnitOfWork(exchange);
        }
    }

    public static class ChildUnitOfWorkProcessorAdvice
    extends UnitOfWorkProcessorAdvice {
        private final UnitOfWork parent;

        public ChildUnitOfWorkProcessorAdvice(RouteContext routeContext, UnitOfWork parent) {
            super(routeContext);
            this.parent = parent;
        }

        @Override
        protected UnitOfWork createUnitOfWork(Exchange exchange) {
            return this.parent.createChildUnitOfWork(exchange);
        }
    }

    public static class UnitOfWorkProcessorAdvice
    implements CamelInternalProcessorAdvice<UnitOfWork> {
        private final RouteContext routeContext;

        public UnitOfWorkProcessorAdvice(RouteContext routeContext) {
            this.routeContext = routeContext;
        }

        @Override
        public UnitOfWork before(Exchange exchange) throws Exception {
            UnitOfWork existing;
            if (this.routeContext != null && exchange.getFromRouteId() == null) {
                String routeId = this.routeContext.getRoute().idOrCreate(this.routeContext.getCamelContext().getNodeIdFactory());
                exchange.setFromRouteId(routeId);
            }
            UnitOfWork created = null;
            if (exchange.getUnitOfWork() == null) {
                created = this.createUnitOfWork(exchange);
                exchange.setUnitOfWork(created);
                created.start();
            }
            if (this.routeContext != null && (existing = exchange.getUnitOfWork()) != null) {
                existing.pushRouteContext(this.routeContext);
            }
            return created;
        }

        @Override
        public void after(Exchange exchange, UnitOfWork uow) throws Exception {
            UnitOfWork existing = exchange.getUnitOfWork();
            if (uow != null) {
                UnitOfWorkHelper.doneUow(uow, exchange);
            }
            if (this.routeContext != null && existing != null) {
                existing.popRouteContext();
            }
        }

        protected UnitOfWork createUnitOfWork(Exchange exchange) {
            return exchange.getContext().getUnitOfWorkFactory().createUnitOfWork(exchange);
        }
    }

    public static final class BacklogDebuggerAdvice
    implements CamelInternalProcessorAdvice<StopWatch> {
        private final BacklogDebugger backlogDebugger;
        private final Processor target;
        private final ProcessorDefinition<?> definition;
        private final String nodeId;

        public BacklogDebuggerAdvice(BacklogDebugger backlogDebugger, Processor target, ProcessorDefinition<?> definition) {
            this.backlogDebugger = backlogDebugger;
            this.target = target;
            this.definition = definition;
            this.nodeId = definition.getId();
        }

        @Override
        public StopWatch before(Exchange exchange) throws Exception {
            if (this.backlogDebugger.isEnabled() && (this.backlogDebugger.hasBreakpoint(this.nodeId) || this.backlogDebugger.isSingleStepMode())) {
                StopWatch watch = new StopWatch();
                this.backlogDebugger.beforeProcess(exchange, this.target, this.definition);
                return watch;
            }
            return null;
        }

        @Override
        public void after(Exchange exchange, StopWatch stopWatch) throws Exception {
            if (stopWatch != null) {
                this.backlogDebugger.afterProcess(exchange, this.target, this.definition, stopWatch.stop());
            }
        }
    }

    public static final class BacklogTracerAdvice
    implements CamelInternalProcessorAdvice {
        private final BacklogTracer backlogTracer;
        private final ProcessorDefinition<?> processorDefinition;
        private final ProcessorDefinition<?> routeDefinition;
        private final boolean first;

        public BacklogTracerAdvice(BacklogTracer backlogTracer, ProcessorDefinition<?> processorDefinition, ProcessorDefinition<?> routeDefinition, boolean first) {
            this.backlogTracer = backlogTracer;
            this.processorDefinition = processorDefinition;
            this.routeDefinition = routeDefinition;
            this.first = first;
        }

        public Object before(Exchange exchange) throws Exception {
            if (this.backlogTracer.shouldTrace(this.processorDefinition, exchange)) {
                String routeId;
                Date timestamp = new Date();
                String toNode = this.processorDefinition.getId();
                String exchangeId = exchange.getExchangeId();
                String messageAsXml = MessageHelper.dumpAsXml(exchange.getIn(), true, 4, this.backlogTracer.isBodyIncludeStreams(), this.backlogTracer.isBodyIncludeFiles(), this.backlogTracer.getBodyMaxChars());
                String string = routeId = this.routeDefinition != null ? this.routeDefinition.getId() : null;
                if (this.first) {
                    Date created = exchange.getProperty("CamelCreatedTimestamp", timestamp, Date.class);
                    DefaultBacklogTracerEventMessage pseudo = new DefaultBacklogTracerEventMessage(this.backlogTracer.incrementTraceCounter(), created, routeId, null, exchangeId, messageAsXml);
                    this.backlogTracer.traceEvent(pseudo);
                }
                DefaultBacklogTracerEventMessage event = new DefaultBacklogTracerEventMessage(this.backlogTracer.incrementTraceCounter(), timestamp, routeId, toNode, exchangeId, messageAsXml);
                this.backlogTracer.traceEvent(event);
            }
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
        }
    }

    public static class RoutePolicyAdvice
    implements CamelInternalProcessorAdvice {
        private final List<RoutePolicy> routePolicies;
        private Route route;

        public RoutePolicyAdvice(List<RoutePolicy> routePolicies) {
            this.routePolicies = routePolicies;
        }

        public void setRoute(Route route) {
            this.route = route;
        }

        protected boolean isRoutePolicyRunAllowed(RoutePolicy policy) {
            if (policy instanceof StatefulService) {
                StatefulService ss = (StatefulService)((Object)policy);
                return ss.isRunAllowed();
            }
            return true;
        }

        public Object before(Exchange exchange) throws Exception {
            for (RoutePolicy policy : this.routePolicies) {
                try {
                    if (!this.isRoutePolicyRunAllowed(policy)) continue;
                    policy.onExchangeBegin(this.route, exchange);
                }
                catch (Exception e) {
                    LOG.warn("Error occurred during onExchangeBegin on RoutePolicy: " + policy + ". This exception will be ignored", (Throwable)e);
                }
            }
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
            if (RoutePolicyAdvice.isCamelStopping(exchange.getContext())) {
                return;
            }
            for (RoutePolicy policy : this.routePolicies) {
                try {
                    if (!this.isRoutePolicyRunAllowed(policy)) continue;
                    policy.onExchangeDone(this.route, exchange);
                }
                catch (Exception e) {
                    LOG.warn("Error occurred during onExchangeDone on RoutePolicy: " + policy + ". This exception will be ignored", (Throwable)e);
                }
            }
        }

        private static boolean isCamelStopping(CamelContext context) {
            if (context instanceof StatefulService) {
                StatefulService ss = (StatefulService)((Object)context);
                return ss.isStopping() || ss.isStopped();
            }
            return false;
        }
    }

    public static class RouteInflightRepositoryAdvice
    implements CamelInternalProcessorAdvice {
        private final InflightRepository inflightRepository;
        private final String id;

        public RouteInflightRepositoryAdvice(InflightRepository inflightRepository, String id) {
            this.inflightRepository = inflightRepository;
            this.id = id;
        }

        public Object before(Exchange exchange) throws Exception {
            this.inflightRepository.add(exchange, this.id);
            return null;
        }

        public void after(Exchange exchange, Object state) throws Exception {
            this.inflightRepository.remove(exchange, this.id);
        }
    }

    @Deprecated
    public static class RouteContextAdvice
    implements CamelInternalProcessorAdvice<UnitOfWork> {
        private final RouteContext routeContext;

        public RouteContextAdvice(RouteContext routeContext) {
            this.routeContext = routeContext;
        }

        @Override
        public UnitOfWork before(Exchange exchange) throws Exception {
            UnitOfWork unitOfWork = exchange.getUnitOfWork();
            if (unitOfWork != null) {
                unitOfWork.pushRouteContext(this.routeContext);
            }
            return unitOfWork;
        }

        @Override
        public void after(Exchange exchange, UnitOfWork unitOfWork) throws Exception {
            if (unitOfWork != null) {
                unitOfWork.popRouteContext();
            }
        }
    }

    public static class InstrumentationAdvice
    implements CamelInternalProcessorAdvice<StopWatch> {
        private PerformanceCounter counter;
        private String type;

        public InstrumentationAdvice(String type) {
            this.type = type;
        }

        public void setCounter(Object counter) {
            ManagedPerformanceCounter mpc = null;
            if (counter instanceof ManagedPerformanceCounter) {
                mpc = (ManagedPerformanceCounter)counter;
            }
            if (this.counter instanceof DelegatePerformanceCounter) {
                ((DelegatePerformanceCounter)this.counter).setCounter(mpc);
            } else if (mpc != null) {
                this.counter = mpc;
            } else if (counter instanceof PerformanceCounter) {
                this.counter = (PerformanceCounter)counter;
            }
        }

        protected void beginTime(Exchange exchange) {
            this.counter.processExchange(exchange);
        }

        protected void recordTime(Exchange exchange, long duration) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}Recording duration: {} millis for exchange: {}", new Object[]{this.type != null ? this.type + ": " : "", duration, exchange});
            }
            if (!exchange.isFailed() && exchange.getException() == null) {
                this.counter.completedExchange(exchange, duration);
            } else {
                this.counter.failedExchange(exchange);
            }
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Override
        public StopWatch before(Exchange exchange) throws Exception {
            StopWatch answer;
            StopWatch stopWatch = answer = this.counter != null && this.counter.isStatisticsEnabled() ? new StopWatch() : null;
            if (answer != null) {
                this.beginTime(exchange);
            }
            return answer;
        }

        @Override
        public void after(Exchange exchange, StopWatch watch) throws Exception {
            if (watch != null) {
                this.recordTime(exchange, watch.stop());
            }
        }
    }

    public static class RouteLifecycleAdvice
    implements CamelInternalProcessorAdvice<Object> {
        private Route route;

        public void setRoute(Route route) {
            this.route = route;
        }

        @Override
        public Object before(Exchange exchange) throws Exception {
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow != null) {
                uow.beforeRoute(exchange, this.route);
            }
            return null;
        }

        @Override
        public void after(Exchange exchange, Object object) throws Exception {
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow != null) {
                uow.afterRoute(exchange, this.route);
            }
        }
    }

    private final class InternalCallback
    implements AsyncCallback {
        private final List<Object> states;
        private final Exchange exchange;
        private final AsyncCallback callback;

        private InternalCallback(List<Object> states, Exchange exchange, AsyncCallback callback) {
            this.states = states;
            this.exchange = exchange;
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done(boolean doneSync) {
            try {
                for (int i = CamelInternalProcessor.this.advices.size() - 1; i >= 0; --i) {
                    CamelInternalProcessorAdvice task = (CamelInternalProcessorAdvice)CamelInternalProcessor.this.advices.get(i);
                    Object state = this.states.get(i);
                    try {
                        task.after(this.exchange, state);
                        continue;
                    }
                    catch (Exception e) {
                        this.exchange.setException(e);
                    }
                }
            }
            finally {
                this.callback.done(doneSync);
            }
        }
    }
}

