/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class FluentProducerTemplate {
    private final CamelContext context;
    private Map<String, Object> headers;
    private Object body;
    private Endpoint endpoint;
    private Consumer<ProducerTemplate> templateCustomizer;
    private Supplier<Exchange> exchangeSupplier;
    private Supplier<Processor> processorSupplier;
    private ProducerTemplate template;

    public FluentProducerTemplate(CamelContext context) {
        this.context = context;
        this.headers = null;
        this.body = null;
        this.endpoint = null;
        this.templateCustomizer = null;
        this.exchangeSupplier = null;
        this.processorSupplier = () -> this::populateExchange;
        this.template = null;
    }

    public FluentProducerTemplate withHeader(String key, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        this.headers.put(key, value);
        return this;
    }

    public FluentProducerTemplate clearHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
        return this;
    }

    public FluentProducerTemplate withBody(Object body) {
        this.body = body;
        return this;
    }

    public FluentProducerTemplate withBodyAs(Object body, Class<?> type) {
        this.body = type != null ? this.context.getTypeConverter().convertTo(type, body) : body;
        return this;
    }

    public FluentProducerTemplate clearBody() {
        this.body = null;
        return this;
    }

    public FluentProducerTemplate withTemplateCustomizer(Consumer<ProducerTemplate> templateCustomizer) {
        this.templateCustomizer = templateCustomizer;
        return this;
    }

    public FluentProducerTemplate withExchange(Exchange exchange) {
        return this.withExchange(() -> exchange);
    }

    public FluentProducerTemplate withExchange(Supplier<Exchange> exchangeSupplier) {
        this.exchangeSupplier = exchangeSupplier;
        return this;
    }

    public FluentProducerTemplate withProcessor(Processor processor) {
        return this.withProcessor(() -> processor);
    }

    public FluentProducerTemplate withProcessor(Supplier<Processor> processorSupplier) {
        this.processorSupplier = processorSupplier;
        return this;
    }

    public FluentProducerTemplate to(String endpointUri) {
        return this.to(this.context.getEndpoint(endpointUri));
    }

    public FluentProducerTemplate to(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Object request() throws CamelExecutionException {
        return this.request(Object.class);
    }

    public <T> T request(Class<T> type) throws CamelExecutionException {
        Object result;
        if (type == Exchange.class) {
            result = this.template().request(this.endpoint, this.processorSupplier.get());
        } else if (type == Message.class) {
            Exchange exchange = this.template().request(this.endpoint, this.processorSupplier.get());
            result = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        } else {
            Exchange exchange = this.template().send(this.endpoint, ExchangePattern.InOut, this.processorSupplier.get());
            result = this.context.getTypeConverter().convertTo(type, ExchangeHelper.extractResultBody(exchange, exchange.getPattern()));
        }
        return (T)result;
    }

    public Future<Object> asyncRequest() {
        return this.asyncRequest(Object.class);
    }

    public <T> Future<T> asyncRequest(Class<T> type) {
        Future<T> result = this.headers != null ? this.template().asyncRequestBodyAndHeaders(this.endpoint, this.body, this.headers, type) : this.template().asyncRequestBody(this.endpoint, this.body, type);
        return result;
    }

    public Exchange send() throws CamelExecutionException {
        return this.exchangeSupplier != null ? this.template().send(this.endpoint, this.exchangeSupplier.get()) : this.template().send(this.endpoint, this.processorSupplier.get());
    }

    public Future<Exchange> asyncSend() {
        return this.exchangeSupplier != null ? this.template().asyncSend(this.endpoint, this.exchangeSupplier.get()) : this.template().asyncSend(this.endpoint, this.processorSupplier.get());
    }

    public static FluentProducerTemplate on(CamelContext context) {
        return new FluentProducerTemplate(context);
    }

    private ProducerTemplate template() {
        ObjectHelper.notNull(this.context, "camel-context");
        ObjectHelper.notNull(this.endpoint, "endpoint");
        if (this.template == null) {
            this.template = this.context.createProducerTemplate();
            if (this.templateCustomizer != null) {
                this.templateCustomizer.accept(this.template);
            }
        }
        return this.template;
    }

    private void populateExchange(Exchange exchange) throws Exception {
        if (this.headers != null && !this.headers.isEmpty()) {
            exchange.getIn().getHeaders().putAll(this.headers);
        }
        if (this.body != null) {
            exchange.getIn().setBody(this.body);
        }
    }
}

