/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.component.bean.BeanEndpoint;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.ServiceHelper;

public class BeanProducer
extends DefaultAsyncProducer {
    private final BeanProcessor processor;
    private boolean beanStarted;

    public BeanProducer(BeanEndpoint endpoint, BeanProcessor processor) {
        super(endpoint);
        this.processor = processor;
        this.beanStarted = false;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.processor.getBeanHolder() instanceof ConstantBeanHolder) {
            try {
                ServiceHelper.startService(this.processor.getBean());
                this.beanStarted = true;
            }
            catch (NoSuchBeanException noSuchBeanException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.beanStarted) {
            try {
                ServiceHelper.stopService(this.processor.getBean());
                this.beanStarted = false;
            }
            catch (NoSuchBeanException noSuchBeanException) {
                // empty catch block
            }
        }
        super.doStop();
    }
}

