/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.com.github.benmanes.caffeine.cache;

import java.util.Objects;
import org.apache.camel.com.github.benmanes.caffeine.base.UnsafeAccess;
import org.apache.camel.com.github.benmanes.caffeine.cache.BoundedLocalCache;
import org.apache.camel.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.camel.com.github.benmanes.caffeine.cache.WBHeader;

final class WriteBuffer<E>
extends WBHeader.ConsumerRef<E> {
    long p60;
    long p61;
    long p62;
    long p63;
    long p64;
    long p65;
    long p66;
    long p67;
    long p70;
    long p71;
    long p72;
    long p73;
    long p74;
    long p75;
    long p76;
    static final long ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
    static final Object JUMP = new Object();
    static final int ELEMENT_SHIFT;

    public WriteBuffer(int initialCapacity, int maxCapacity) {
        Caffeine.requireArgument(maxCapacity > 4);
        Caffeine.requireArgument(initialCapacity > 2);
        if (BoundedLocalCache.ceilingPowerOfTwo(initialCapacity) >= BoundedLocalCache.ceilingPowerOfTwo(maxCapacity)) {
            throw new IllegalArgumentException("Initial capacity cannot exceed maximum capacity(both rounded up to a power of 2)");
        }
        int p2capacity = BoundedLocalCache.ceilingPowerOfTwo(initialCapacity);
        long mask = p2capacity - 1 << 1;
        Object[] buffer = new Object[p2capacity + 1];
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.maxQueueCapacity = BoundedLocalCache.ceilingPowerOfTwo(maxCapacity) << 1;
        this.soProducerLimit(mask);
    }

    public boolean offer(E e) {
        Object[] buffer;
        long mask;
        long producerIndex;
        Objects.requireNonNull(e);
        block6: while (true) {
            long producerLimit = this.lvProducerLimit();
            producerIndex = this.lvProducerIndex();
            if ((producerIndex & 1L) == 1L) continue;
            mask = this.producerMask;
            buffer = this.producerBuffer;
            if (producerLimit <= producerIndex) {
                int result = this.offerSlowPath(e, mask, buffer, producerIndex, producerLimit);
                switch (result) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(producerIndex, producerIndex + 2L)) break;
        }
        long offset = WriteBuffer.modifiedCalcElementOffset(producerIndex, mask);
        UnsafeAccess.UNSAFE.putOrderedObject(buffer, offset, e);
        return true;
    }

    private int offerSlowPath(E e, long mask, E[] buffer, long producerIndex, long producerLimit) {
        int result;
        long bufferCapacity;
        long consumerIndex = this.lvConsumerIndex();
        long maxQueueCapacity = this.maxQueueCapacity;
        long l = bufferCapacity = mask + 2L == maxQueueCapacity ? maxQueueCapacity : mask;
        if (consumerIndex + bufferCapacity > producerIndex) {
            if (!this.casProducerLimit(producerLimit, consumerIndex + bufferCapacity)) {
                boolean bl = true;
            }
            result = 0;
        } else if (consumerIndex == producerIndex - maxQueueCapacity) {
            result = 2;
        } else if (this.casProducerIndex(producerIndex, producerIndex + 1L)) {
            int newBufferLength = buffer.length;
            if ((long)(buffer.length - 1) == maxQueueCapacity) {
                throw new IllegalStateException();
            }
            newBufferLength = 2 * buffer.length - 1;
            Object[] newBuffer = new Object[newBufferLength];
            this.producerBuffer = newBuffer;
            this.producerMask = newBufferLength - 2 << 1;
            long offsetInOld = WriteBuffer.modifiedCalcElementOffset(producerIndex, mask);
            long offsetInNew = WriteBuffer.modifiedCalcElementOffset(producerIndex, this.producerMask);
            UnsafeAccess.UNSAFE.putOrderedObject(newBuffer, offsetInNew, e);
            UnsafeAccess.UNSAFE.putOrderedObject(buffer, this.nextArrayOffset(mask), newBuffer);
            long available = maxQueueCapacity - (producerIndex - consumerIndex);
            if (available <= 0L) {
                throw new IllegalStateException();
            }
            this.soProducerLimit(producerIndex + Math.min(mask, available));
            UnsafeAccess.UNSAFE.putOrderedObject(buffer, offsetInOld, JUMP);
            this.soProducerIndex(producerIndex + 2L);
            result = 3;
        } else {
            result = 1;
        }
        return result;
    }

    public E poll() {
        Object[] buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = WriteBuffer.modifiedCalcElementOffset(index, mask);
        Object e = WriteBuffer.lvElement(buffer, offset);
        if (e == null) {
            if (index != this.lvProducerIndex()) {
                while ((e = WriteBuffer.lvElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        if (e == JUMP) {
            Object[] nextBuffer = this.getNextBuffer(buffer, mask);
            return (E)this.newBufferPoll(nextBuffer, index);
        }
        WriteBuffer.soElement(buffer, offset, null);
        this.soConsumerIndex(index + 2L);
        Object casted = e;
        return (E)casted;
    }

    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after) >> 1;
    }

    private static long modifiedCalcElementOffset(long index, long mask) {
        return ARRAY_BASE + ((index & mask) << ELEMENT_SHIFT - 1);
    }

    private E[] getNextBuffer(E[] buffer, long mask) {
        long nextArrayOffset = this.nextArrayOffset(mask);
        Object[] nextBuffer = (Object[])UnsafeAccess.UNSAFE.getObjectVolatile(buffer, nextArrayOffset);
        UnsafeAccess.UNSAFE.putOrderedObject(buffer, nextArrayOffset, null);
        return nextBuffer;
    }

    private long nextArrayOffset(long mask) {
        return WriteBuffer.modifiedCalcElementOffset(mask + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(E[] nextBuffer, long index) {
        long offsetInNew = this.newBufferAndOffset(nextBuffer, index);
        Object n = UnsafeAccess.UNSAFE.getObjectVolatile(nextBuffer, offsetInNew);
        if (n == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        UnsafeAccess.UNSAFE.putOrderedObject(nextBuffer, offsetInNew, null);
        this.soConsumerIndex(index + 2L);
        return (E)n;
    }

    private long newBufferAndOffset(E[] nextBuffer, long index) {
        this.consumerBuffer = nextBuffer;
        this.consumerMask = nextBuffer.length - 2 << 1;
        long offsetInNew = WriteBuffer.modifiedCalcElementOffset(index, this.consumerMask);
        return offsetInNew;
    }

    public static <E> E lvElement(E[] buffer, long offset) {
        return (E)UnsafeAccess.UNSAFE.getObjectVolatile(buffer, offset);
    }

    public static <E> void soElement(E[] buffer, long offset, E e) {
        UnsafeAccess.UNSAFE.putOrderedObject(buffer, offset, e);
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }

    private void soProducerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, v);
    }

    private boolean casProducerIndex(long expect, long newValue) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, P_INDEX_OFFSET, expect, newValue);
    }

    private void soConsumerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, v);
    }

    private long lvProducerLimit() {
        return this.producerLimit;
    }

    private boolean casProducerLimit(long expect, long newValue) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, P_LIMIT_OFFSET, expect, newValue);
    }

    private void soProducerLimit(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_LIMIT_OFFSET, v);
    }

    static {
        int scale = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
        if (scale == 4) {
            ELEMENT_SHIFT = 2;
        } else if (scale == 8) {
            ELEMENT_SHIFT = 3;
        } else {
            throw new IllegalStateException("Unknown pointer size");
        }
    }
}

