/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XMLReaderPool {
    private final Queue<WeakReference<XMLReader>> pool = new ConcurrentLinkedQueue<WeakReference<XMLReader>>();
    private final SAXParserFactory saxParserFactory;

    public XMLReaderPool(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public XMLReader createXMLReader() throws SAXException, ParserConfigurationException {
        WeakReference<XMLReader> ref;
        XMLReader xmlReader = null;
        while ((ref = this.pool.poll()) != null && (xmlReader = (XMLReader)ref.get()) == null) {
        }
        if (xmlReader == null) {
            xmlReader = this.saxParserFactory.newSAXParser().getXMLReader();
        }
        return new OneTimeXMLReader(xmlReader);
    }

    private final class OneTimeXMLReader
    implements XMLReader {
        private XMLReader xmlReader;
        private final Map<String, Boolean> initFeatures = new HashMap<String, Boolean>();
        private final Map<String, Object> initProperties = new HashMap<String, Object>();
        private final ContentHandler initContentHandler;
        private final DTDHandler initDtdHandler;
        private final EntityResolver initEntityResolver;
        private final ErrorHandler initErrorHandler;

        private OneTimeXMLReader(XMLReader xmlReader) {
            this.xmlReader = xmlReader;
            this.initContentHandler = xmlReader.getContentHandler();
            this.initDtdHandler = xmlReader.getDTDHandler();
            this.initEntityResolver = xmlReader.getEntityResolver();
            this.initErrorHandler = xmlReader.getErrorHandler();
        }

        private void release() {
            for (Map.Entry<String, Boolean> feature : this.initFeatures.entrySet()) {
                try {
                    this.xmlReader.setFeature(feature.getKey(), feature.getValue());
                }
                catch (Exception exception) {}
            }
            for (Map.Entry<String, Object> property : this.initProperties.entrySet()) {
                try {
                    this.xmlReader.setProperty(property.getKey(), property.getValue());
                }
                catch (Exception exception) {}
            }
            this.xmlReader.setContentHandler(this.initContentHandler);
            this.xmlReader.setDTDHandler(this.initDtdHandler);
            this.xmlReader.setEntityResolver(this.initEntityResolver);
            this.xmlReader.setErrorHandler(this.initErrorHandler);
            XMLReaderPool.this.pool.offer(new WeakReference<XMLReader>(this.xmlReader));
            this.xmlReader = null;
        }

        private void checkValid() {
            if (this.xmlReader == null) {
                throw new IllegalStateException("OneTimeXMLReader.parse() can only be used once!");
            }
        }

        @Override
        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.checkValid();
            return this.xmlReader.getFeature(name);
        }

        @Override
        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.checkValid();
            if (!this.initFeatures.containsKey(name)) {
                this.initFeatures.put(name, this.xmlReader.getFeature(name));
            }
            this.xmlReader.setFeature(name, value);
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.checkValid();
            return this.xmlReader.getProperty(name);
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.checkValid();
            if (!this.initProperties.containsKey(name)) {
                this.initProperties.put(name, this.xmlReader.getProperty(name));
            }
            this.xmlReader.setProperty(name, value);
        }

        @Override
        public ContentHandler getContentHandler() {
            this.checkValid();
            return this.xmlReader.getContentHandler();
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.checkValid();
            this.xmlReader.setContentHandler(handler);
        }

        @Override
        public DTDHandler getDTDHandler() {
            this.checkValid();
            return this.xmlReader.getDTDHandler();
        }

        @Override
        public void setDTDHandler(DTDHandler handler) {
            this.checkValid();
            this.xmlReader.setDTDHandler(handler);
        }

        @Override
        public EntityResolver getEntityResolver() {
            this.checkValid();
            return this.xmlReader.getEntityResolver();
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
            this.checkValid();
            this.xmlReader.setEntityResolver(resolver);
        }

        @Override
        public ErrorHandler getErrorHandler() {
            this.checkValid();
            return this.xmlReader.getErrorHandler();
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
            this.checkValid();
            this.xmlReader.setErrorHandler(handler);
        }

        @Override
        public void parse(InputSource input) throws IOException, SAXException {
            this.checkValid();
            try {
                this.xmlReader.parse(input);
            }
            finally {
                this.release();
            }
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
            this.checkValid();
            try {
                this.xmlReader.parse(systemId);
            }
            finally {
                this.release();
            }
        }
    }
}

