/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.remote;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.impl.remote.DefaultServiceCallExpression;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ServiceCallLoadBalancer;
import org.apache.camel.spi.ServiceCallServer;
import org.apache.camel.spi.ServiceCallServerListStrategy;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceCallProcessor<S extends ServiceCallServer>
extends ServiceSupport
implements AsyncProcessor,
CamelContextAware,
Traceable,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceCallProcessor.class);
    private final ExchangePattern exchangePattern;
    private final String name;
    private final String scheme;
    private final String uri;
    private final String contextPath;
    private CamelContext camelContext;
    private String id;
    private ServiceCallServerListStrategy<S> serverListStrategy;
    private ServiceCallLoadBalancer<S> loadBalancer;
    private Expression serviceCallExpression;
    private SendDynamicProcessor processor;

    public DefaultServiceCallProcessor(String name, String scheme, String uri, ExchangePattern exchangePattern) {
        String serviceName;
        this.uri = uri;
        this.exchangePattern = exchangePattern;
        if (name.contains("/")) {
            serviceName = ObjectHelper.before(name, "/");
            this.contextPath = ObjectHelper.after(name, "/");
        } else if (name.contains("?")) {
            serviceName = ObjectHelper.before(name, "?");
            this.contextPath = ObjectHelper.after(name, "?");
        } else {
            serviceName = name;
            this.contextPath = null;
        }
        if (serviceName.contains(":")) {
            this.scheme = ObjectHelper.before(serviceName, ":");
            this.name = ObjectHelper.after(serviceName, ":");
        } else {
            this.scheme = scheme;
            this.name = serviceName;
        }
        this.serviceCallExpression = new DefaultServiceCallExpression(this.name, this.scheme, this.contextPath, this.uri);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTraceLabel() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getUri() {
        return this.uri;
    }

    public ExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    public ServiceCallLoadBalancer<S> getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(ServiceCallLoadBalancer<S> loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public DefaultServiceCallProcessor loadBalancer(ServiceCallLoadBalancer<S> loadBalancer) {
        this.setLoadBalancer(loadBalancer);
        return this;
    }

    public ServiceCallServerListStrategy<S> getServerListStrategy() {
        return this.serverListStrategy;
    }

    public void setServerListStrategy(ServiceCallServerListStrategy<S> serverListStrategy) {
        this.serverListStrategy = serverListStrategy;
    }

    public DefaultServiceCallProcessor serverListStrategy(ServiceCallServerListStrategy<S> serverListStrategy) {
        this.setServerListStrategy(serverListStrategy);
        return this;
    }

    public void setServiceCallExpression(Expression serviceCallExpression) {
        this.serviceCallExpression = serviceCallExpression;
    }

    public Expression getServiceCallExpression() {
        return this.serviceCallExpression;
    }

    public DefaultServiceCallProcessor serviceCallExpression(Expression serviceCallExpression) {
        this.setServiceCallExpression(serviceCallExpression);
        return this;
    }

    public AsyncProcessor getProcessor() {
        return this.processor;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notEmpty(this.getName(), "name", "serviceName");
        ObjectHelper.notNull(this.camelContext, "camelContext");
        ObjectHelper.notNull(this.serviceCallExpression, "serviceCallExpression");
        LOG.info("ServiceCall with service name: {} is using load balancer: {} and service discovery: {}", new Object[]{this.name, this.loadBalancer, this.serverListStrategy});
        this.processor = new SendDynamicProcessor(this.uri, this.serviceCallExpression);
        this.processor.setCamelContext(this.getCamelContext());
        if (this.exchangePattern != null) {
            this.processor.setPattern(this.exchangePattern);
        }
        ServiceHelper.startServices(this.serverListStrategy, this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processor, this.serverListStrategy);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        String serviceName = exchange.getIn().getHeader("CamelServiceCallServiceName", this.name, String.class);
        S server = this.chooseServer(exchange, serviceName);
        if (exchange.getException() != null) {
            callback.done(true);
            return true;
        }
        String ip = server.getIp();
        int port = server.getPort();
        LOG.debug("Service {} active at server: {}:{}", new Object[]{this.name, ip, port});
        exchange.getIn().setHeader("CamelServiceCallServerIp", ip);
        exchange.getIn().setHeader("CamelServiceCallServerPort", port);
        exchange.getIn().setHeader("CamelServiceCallServiceName", serviceName);
        return this.processor.process(exchange, callback);
    }

    protected S chooseServer(Exchange exchange, String serviceName) {
        ObjectHelper.notNull(this.serverListStrategy, "serverListStrategy");
        ObjectHelper.notNull(this.loadBalancer, "loadBalancer");
        S server = null;
        try {
            List<S> servers = this.serverListStrategy.getUpdatedListOfServers(serviceName);
            if (servers == null || servers.isEmpty()) {
                exchange.setException(new RejectedExecutionException("No active services with name " + this.name));
            } else {
                server = (S)(servers.size() > 1 ? this.loadBalancer.chooseServer(servers) : (ServiceCallServer)servers.get(0));
                if (server == null) {
                    exchange.setException(new RejectedExecutionException("No active services with name " + this.name));
                }
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        return server;
    }
}

