/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.impl.GzipDataFormat;
import org.apache.camel.impl.springboot.GzipDataFormatConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={GzipDataFormatConfiguration.class})
public class GzipDataFormatAutoConfiguration {
    @Bean(name={"gzip-dataformat"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={GzipDataFormat.class})
    public GzipDataFormat configureGzipDataFormat(CamelContext camelContext, GzipDataFormatConfiguration configuration) throws Exception {
        GzipDataFormat dataformat = new GzipDataFormat();
        if (dataformat instanceof CamelContextAware) {
            ((CamelContextAware)((Object)dataformat)).setCamelContext(camelContext);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(configuration, parameters, null, false);
        IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), dataformat, parameters);
        return dataformat;
    }
}

