/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.impl.SerializationDataFormat;
import org.apache.camel.impl.springboot.SerializationDataFormatConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SerializationDataFormatConfiguration.class})
public class SerializationDataFormatAutoConfiguration {
    @Bean(name={"serialization-dataformat"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={SerializationDataFormat.class})
    public SerializationDataFormat configureSerializationDataFormat(CamelContext camelContext, SerializationDataFormatConfiguration configuration) throws Exception {
        SerializationDataFormat dataformat = new SerializationDataFormat();
        if (dataformat instanceof CamelContextAware) {
            ((CamelContextAware)((Object)dataformat)).setCamelContext(camelContext);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(configuration, parameters, null, false);
        IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), dataformat, parameters);
        return dataformat;
    }
}

