/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.constant.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.language.constant.ConstantLanguage;
import org.apache.camel.language.constant.springboot.ConstantLanguageConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ConstantLanguageConfiguration.class})
public class ConstantLanguageAutoConfiguration {
    @Bean(name={"constant-language"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={ConstantLanguage.class})
    public ConstantLanguage configureConstantLanguage(CamelContext camelContext, ConstantLanguageConfiguration configuration) throws Exception {
        ConstantLanguage language = new ConstantLanguage();
        if (language instanceof CamelContextAware) {
            ((CamelContextAware)((Object)language)).setCamelContext(camelContext);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(configuration, parameters, null, false);
        IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), language, parameters);
        return language;
    }
}

