/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.language.tokenizer.XMLTokenizeLanguage;
import org.apache.camel.language.tokenizer.springboot.XMLTokenizeLanguageConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={XMLTokenizeLanguageConfiguration.class})
public class XMLTokenizeLanguageAutoConfiguration {
    @Bean(name={"xtokenize-language"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={XMLTokenizeLanguage.class})
    public XMLTokenizeLanguage configureXMLTokenizeLanguage(CamelContext camelContext, XMLTokenizeLanguageConfiguration configuration) throws Exception {
        XMLTokenizeLanguage language = new XMLTokenizeLanguage();
        if (language instanceof CamelContextAware) {
            language.setCamelContext(camelContext);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(configuration, parameters, null, false);
        IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), language, parameters);
        return language;
    }
}

