/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.xpath.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.language.xpath.XPathLanguage;
import org.apache.camel.language.xpath.springboot.XPathLanguageConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={XPathLanguageConfiguration.class})
public class XPathLanguageAutoConfiguration {
    @Bean(name={"xpath-language"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={XPathLanguage.class})
    public XPathLanguage configureXPathLanguage(CamelContext camelContext, XPathLanguageConfiguration configuration) throws Exception {
        XPathLanguage language = new XPathLanguage();
        if (language instanceof CamelContextAware) {
            language.setCamelContext(camelContext);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(configuration, parameters, null, false);
        IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), language, parameters);
        return language;
    }
}

