/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Exchange;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceCallExpressionSupport
extends ExpressionAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCallExpressionSupport.class);
    private final String name;
    private final String scheme;
    private final String contextPath;
    private final String uri;

    public ServiceCallExpressionSupport(String name, String scheme, String contextPath, String uri) {
        this.name = name;
        this.scheme = scheme;
        this.contextPath = contextPath;
        this.uri = uri;
    }

    public abstract String getIp(Exchange var1) throws Exception;

    public abstract int getPort(Exchange var1) throws Exception;

    @Override
    public Object evaluate(Exchange exchange) {
        try {
            String ip = this.getIp(exchange);
            int port = this.getPort(exchange);
            return ServiceCallExpressionSupport.buildCamelEndpointUri(ip, port, this.name, this.uri, this.contextPath, this.scheme);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    protected static String buildCamelEndpointUri(String ip, int port, String name, String uri, String contextPath, String scheme) {
        String answer = uri;
        if (answer == null) {
            if (scheme == null) {
                scheme = port == 443 ? "https" : "http";
            }
            answer = scheme + "://" + ip + ":" + port;
            if (contextPath != null) {
                answer = answer + "" + contextPath;
            }
        } else {
            if (answer.contains(name + ".host")) {
                answer = answer.replaceFirst(name + "\\.host", ip);
            }
            if (answer.contains(name + ".port")) {
                answer = answer.replaceFirst(name + "\\.port", "" + port);
            }
            if (answer.contains(name)) {
                answer = answer.replaceFirst(name, ip + ":" + port);
            }
        }
        LOG.debug("Camel endpoint uri: {} for calling service: {} on server {}:{}", new Object[]{answer, name, ip, port});
        return answer;
    }
}

