/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.Aggregator;
import org.apache.camel.processor.aggregate.AggregationCollection;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.GroupedExchangeAggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="aggregate")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AggregateDefinition
extends ProcessorDefinition<AggregateDefinition> {
    @XmlElement(name="correlationExpression", required=false)
    private ExpressionSubElementDefinition correlationExpression;
    @XmlTransient
    private ExpressionDefinition expression;
    @XmlElementRef
    private List<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private AggregationCollection aggregationCollection;
    @XmlAttribute(required=false)
    private Integer batchSize;
    @XmlAttribute(required=false)
    private Integer outBatchSize;
    @XmlAttribute(required=false)
    private Long batchTimeout;
    @XmlAttribute(required=false)
    private String strategyRef;
    @XmlAttribute(required=false)
    private String collectionRef;
    @XmlAttribute(required=false)
    private Boolean groupExchanges;
    @XmlAttribute(required=false)
    private Boolean batchSizeFromConsumer;
    @XmlElement(name="completionPredicate", required=false)
    private ExpressionSubElementDefinition completionPredicate;

    public AggregateDefinition() {
    }

    public AggregateDefinition(Predicate predicate) {
        if (predicate != null) {
            this.setExpression(new ExpressionDefinition(predicate));
        }
    }

    public AggregateDefinition(Expression correlationExpression) {
        if (correlationExpression != null) {
            this.setExpression(new ExpressionDefinition(correlationExpression));
        }
    }

    public AggregateDefinition(ExpressionDefinition correlationExpression) {
        this.expression = correlationExpression;
    }

    public AggregateDefinition(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        this(correlationExpression);
        this.aggregationStrategy = aggregationStrategy;
    }

    public String toString() {
        String expressionString = this.getExpression() != null ? this.getExpression().getLabel() : "";
        return "Aggregate[" + expressionString + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "aggregate";
    }

    @Override
    public String getLabel() {
        return "aggregate";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        return this.createAggregator(routeContext);
    }

    public ExpressionClause<AggregateDefinition> createAndSetExpression() {
        ExpressionClause<AggregateDefinition> clause = new ExpressionClause<AggregateDefinition>(this);
        this.setExpression(clause);
        return clause;
    }

    protected Aggregator createAggregator(RouteContext routeContext) throws Exception {
        Aggregator aggregator;
        Processor processor = routeContext.createProcessor(this);
        if (this.getAggregationCollection() == null) {
            this.setAggregationCollection(this.createAggregationCollection(routeContext));
        }
        if (this.aggregationCollection != null) {
            if (this.aggregationCollection.getCorrelationExpression() == null) {
                this.aggregationCollection.setCorrelationExpression(this.getExpression());
            }
            if (this.aggregationCollection.getAggregationStrategy() == null) {
                AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
                this.aggregationCollection.setAggregationStrategy(strategy);
            }
            aggregator = new Aggregator(processor, this.aggregationCollection);
        } else {
            AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
            if (this.getExpression() == null) {
                throw new IllegalArgumentException("You need to specify an expression or aggregation collection for this aggregator: " + this);
            }
            Expression aggregateExpression = this.getExpression().createExpression(routeContext);
            Predicate predicate = null;
            if (this.getCompletionPredicate() != null) {
                predicate = this.getCompletionPredicate().createPredicate(routeContext);
            }
            aggregator = predicate != null ? new Aggregator(processor, aggregateExpression, strategy, predicate) : new Aggregator(processor, aggregateExpression, strategy);
        }
        if (this.batchSize != null) {
            aggregator.setBatchSize(this.batchSize);
        }
        if (this.batchTimeout != null) {
            aggregator.setBatchTimeout(this.batchTimeout);
        }
        if (this.outBatchSize != null) {
            aggregator.setOutBatchSize(this.outBatchSize);
        }
        if (this.groupExchanges != null) {
            aggregator.setGroupExchanges(this.groupExchanges);
        }
        if (this.batchSizeFromConsumer != null) {
            aggregator.setBatchConsumer(this.batchSizeFromConsumer);
        }
        return aggregator;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy == null && this.strategyRef != null) {
            strategy = routeContext.lookup(this.strategyRef, AggregationStrategy.class);
        }
        if (strategy == null) {
            strategy = this.groupExchanges != null && this.groupExchanges != false ? new GroupedExchangeAggregationStrategy() : new UseLatestAggregationStrategy();
        }
        return strategy;
    }

    private AggregationCollection createAggregationCollection(RouteContext routeContext) {
        AggregationCollection collection = this.getAggregationCollection();
        if (collection == null && this.collectionRef != null) {
            collection = routeContext.lookup(this.collectionRef, AggregationCollection.class);
        }
        return collection;
    }

    public AggregationCollection getAggregationCollection() {
        return this.aggregationCollection;
    }

    public void setAggregationCollection(AggregationCollection aggregationCollection) {
        this.aggregationCollection = aggregationCollection;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Integer getOutBatchSize() {
        return this.outBatchSize;
    }

    public void setOutBatchSize(Integer outBatchSize) {
        this.outBatchSize = outBatchSize;
    }

    public Long getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(Long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    public String getCollectionRef() {
        return this.collectionRef;
    }

    public void setCollectionRef(String collectionRef) {
        this.collectionRef = collectionRef;
    }

    public void setCompletionPredicate(ExpressionSubElementDefinition completionPredicate) {
        this.completionPredicate = completionPredicate;
    }

    public ExpressionSubElementDefinition getCompletionPredicate() {
        return this.completionPredicate;
    }

    public Boolean getGroupExchanges() {
        return this.groupExchanges;
    }

    public void setGroupExchanges(Boolean groupExchanges) {
        this.groupExchanges = groupExchanges;
    }

    public Boolean getBatchSizeFromConsumer() {
        return this.batchSizeFromConsumer;
    }

    public void setBatchSizeFromConsumer(Boolean batchSizeFromConsumer) {
        this.batchSizeFromConsumer = batchSizeFromConsumer;
    }

    public AggregateDefinition batchSizeFromConsumer() {
        this.setBatchSizeFromConsumer(true);
        return this;
    }

    public AggregateDefinition batchSize(int batchSize) {
        this.setBatchSize(batchSize);
        return this;
    }

    public AggregateDefinition outBatchSize(int batchSize) {
        this.setOutBatchSize(batchSize);
        return this;
    }

    public AggregateDefinition batchTimeout(long batchTimeout) {
        this.setBatchTimeout(batchTimeout);
        return this;
    }

    public AggregateDefinition aggregationCollection(AggregationCollection aggregationCollection) {
        this.setAggregationCollection(aggregationCollection);
        return this;
    }

    public AggregateDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public AggregateDefinition collectionRef(String collectionRef) {
        this.setCollectionRef(collectionRef);
        return this;
    }

    public AggregateDefinition strategyRef(String strategyRef) {
        this.setStrategyRef(strategyRef);
        return this;
    }

    public AggregateDefinition groupExchanges() {
        this.setGroupExchanges(true);
        return this;
    }

    public ExpressionClause<AggregateDefinition> completionPredicate() {
        this.checkNoCompletedPredicate();
        ExpressionClause<AggregateDefinition> clause = new ExpressionClause<AggregateDefinition>(this);
        this.setCompletionPredicate(new ExpressionSubElementDefinition(clause));
        return clause;
    }

    public AggregateDefinition completionPredicate(Predicate predicate) {
        this.checkNoCompletedPredicate();
        this.setCompletionPredicate(new ExpressionSubElementDefinition(predicate));
        return this;
    }

    protected void checkNoCompletedPredicate() {
        if (this.getCompletionPredicate() != null) {
            throw new IllegalArgumentException("There is already a completionPredicate defined for this aggregator: " + this);
        }
    }

    public void setCorrelationExpression(ExpressionSubElementDefinition correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    public ExpressionSubElementDefinition getCorrelationExpression() {
        return this.correlationExpression;
    }

    public ExpressionDefinition getExpression() {
        if (this.expression == null && this.correlationExpression != null) {
            this.expression = this.correlationExpression.getExpressionType();
        }
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition> outputs) {
        this.outputs = outputs;
    }
}

