/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.URIResolver;
import org.apache.camel.Endpoint;
import org.apache.camel.component.xslt.DefaultXsltUriResolverFactory;
import org.apache.camel.component.xslt.XsltEndpoint;
import org.apache.camel.component.xslt.XsltUriResolverFactory;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(XsltComponent.class);
    @Metadata(label="advanced")
    private XmlConverter xmlConverter;
    @Metadata(label="advanced")
    private URIResolver uriResolver;
    @Metadata(label="advanced")
    private XsltUriResolverFactory uriResolverFactory;
    @Metadata(label="advanced")
    private Object saxonConfiguration;
    @Metadata(label="advanced")
    private Map<String, Object> saxonConfigurationProperties = new HashMap<String, Object>();
    @Metadata(label="advanced", javaType="java.lang.String")
    private List<Object> saxonExtensionFunctions;
    @Metadata(defaultValue="true")
    private boolean contentCache = true;
    private boolean saxon;

    public XsltComponent() {
        super(XsltEndpoint.class);
    }

    public XmlConverter getXmlConverter() {
        return this.xmlConverter;
    }

    public void setXmlConverter(XmlConverter xmlConverter) {
        this.xmlConverter = xmlConverter;
    }

    public XsltUriResolverFactory getUriResolverFactory() {
        return this.uriResolverFactory;
    }

    public void setUriResolverFactory(XsltUriResolverFactory uriResolverFactory) {
        this.uriResolverFactory = uriResolverFactory;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public boolean isSaxon() {
        return this.saxon;
    }

    public void setSaxon(boolean saxon) {
        this.saxon = saxon;
    }

    public List<Object> getSaxonExtensionFunctions() {
        return this.saxonExtensionFunctions;
    }

    public void setSaxonExtensionFunctions(List<Object> extensionFunctions) {
        this.saxonExtensionFunctions = extensionFunctions;
    }

    public void setSaxonExtensionFunctions(String extensionFunctions) {
        this.saxonExtensionFunctions = EndpointHelper.resolveReferenceListParameter(this.getCamelContext(), extensionFunctions, Object.class);
    }

    public Object getSaxonConfiguration() {
        return this.saxonConfiguration;
    }

    public void setSaxonConfiguration(Object saxonConfiguration) {
        this.saxonConfiguration = saxonConfiguration;
    }

    public Map<String, Object> getSaxonConfigurationProperties() {
        return this.saxonConfigurationProperties;
    }

    public void setSaxonConfigurationProperties(Map<String, Object> configurationProperties) {
        this.saxonConfigurationProperties = configurationProperties;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        XsltEndpoint endpoint = new XsltEndpoint(uri, this);
        endpoint.setConverter(this.getXmlConverter());
        endpoint.setContentCache(this.isContentCache());
        endpoint.setSaxon(this.isSaxon());
        endpoint.setSaxonConfiguration(this.saxonConfiguration);
        endpoint.setSaxonConfigurationProperties(this.saxonConfigurationProperties);
        endpoint.setSaxonExtensionFunctions(this.saxonExtensionFunctions);
        String resourceUri = remaining;
        if (ResourceHelper.isHttpUri(resourceUri)) {
            resourceUri = ResourceHelper.appendParameters(resourceUri, parameters);
        }
        LOG.debug("{} using schema resource: {}", (Object)this, (Object)resourceUri);
        endpoint.setResourceUri(resourceUri);
        URIResolver resolver = this.resolveAndRemoveReferenceParameter(parameters, "uriResolver", URIResolver.class);
        if (resolver == null) {
            resolver = this.getUriResolver();
        }
        if (resolver == null) {
            XsltUriResolverFactory resolverFactory = this.resolveAndRemoveReferenceParameter(parameters, "uriResolverFactory", XsltUriResolverFactory.class);
            if (resolverFactory == null) {
                resolverFactory = this.getUriResolverFactory();
            }
            if (resolverFactory == null) {
                resolverFactory = new DefaultXsltUriResolverFactory();
            }
            resolver = resolverFactory.createUriResolver(this.getCamelContext(), remaining);
        }
        endpoint.setUriResolver(resolver);
        this.setProperties(endpoint, parameters);
        if (!parameters.isEmpty()) {
            endpoint.setParameters(parameters);
        }
        return endpoint;
    }
}

