/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultUnitOfWork;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UnitOfWorkProcessor
extends DelegateProcessor {
    private static final transient Log LOG = LogFactory.getLog(UnitOfWorkProcessor.class);
    private final RouteContext routeContext;

    public UnitOfWorkProcessor(Processor processor) {
        this(null, processor);
    }

    public UnitOfWorkProcessor(RouteContext routeContext, Processor processor) {
        super(processor);
        this.routeContext = routeContext;
    }

    public String toString() {
        return "UnitOfWork(" + this.processor + ")";
    }

    public RouteContext getRouteContext() {
        return this.routeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNext(Exchange exchange) throws Exception {
        if (exchange.getUnitOfWork() == null) {
            DefaultUnitOfWork uow = new DefaultUnitOfWork(exchange);
            exchange.setUnitOfWork(uow);
            try {
                uow.start();
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
            try {
                this.processor.process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            finally {
                this.done(uow, exchange);
            }
        } else {
            this.processor.process(exchange);
        }
    }

    private void done(DefaultUnitOfWork uow, Exchange exchange) {
        exchange.getUnitOfWork().done(exchange);
        try {
            uow.stop();
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception occurred during stopping UnitOfWork for Exchange: " + exchange + ". This exception will be ignored."));
        }
        exchange.setUnitOfWork(null);
    }
}

