/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.GenericFileProcessStrategySupport;
import org.apache.camel.component.file.strategy.GenericFileRenamer;

public class GenericFileRenameProcessStrategy<T>
extends GenericFileProcessStrategySupport<T> {
    private GenericFileRenamer<T> beginRenamer;
    private GenericFileRenamer<T> failureRenamer;
    private GenericFileRenamer<T> commitRenamer;

    @Override
    public boolean begin(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        GenericFile<T> newName;
        GenericFile<T> to;
        boolean result = super.begin(operations, endpoint, exchange, file);
        if (!result) {
            return false;
        }
        if (this.beginRenamer != null && (to = this.renameFile(operations, file, newName = this.beginRenamer.renameFile(exchange, file))) != null) {
            to.bindToExchange(exchange);
        }
        return true;
    }

    @Override
    public void rollback(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        super.rollback(operations, endpoint, exchange, file);
        if (this.failureRenamer != null) {
            Exchange copy = exchange.copy();
            file.bindToExchange(copy);
            copy.getIn().setMessageId(exchange.getIn().getMessageId());
            copy.setExchangeId(exchange.getExchangeId());
            GenericFile<T> newName = this.failureRenamer.renameFile(copy, file);
            this.renameFile(operations, file, newName);
        }
    }

    @Override
    public void commit(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        super.commit(operations, endpoint, exchange, file);
        if (this.commitRenamer != null) {
            Exchange copy = exchange.copy();
            file.bindToExchange(copy);
            copy.getIn().setMessageId(exchange.getIn().getMessageId());
            copy.setExchangeId(exchange.getExchangeId());
            GenericFile<T> newName = this.commitRenamer.renameFile(copy, file);
            this.renameFile(operations, file, newName);
        }
    }

    public GenericFileRenamer<T> getBeginRenamer() {
        return this.beginRenamer;
    }

    public void setBeginRenamer(GenericFileRenamer<T> beginRenamer) {
        this.beginRenamer = beginRenamer;
    }

    public GenericFileRenamer<T> getCommitRenamer() {
        return this.commitRenamer;
    }

    public void setCommitRenamer(GenericFileRenamer<T> commitRenamer) {
        this.commitRenamer = commitRenamer;
    }

    public GenericFileRenamer<T> getFailureRenamer() {
        return this.failureRenamer;
    }

    public void setFailureRenamer(GenericFileRenamer<T> failureRenamer) {
        this.failureRenamer = failureRenamer;
    }
}

