/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultUnitOfWork;
import org.apache.camel.spi.RouteContext;
import org.slf4j.MDC;

public class MDCUnitOfWork
extends DefaultUnitOfWork {
    public static final String MDC_EXCHANGE_ID = "exchangeId";
    public static final String MDC_CORRELATION_ID = "correlationId";
    public static final String MDC_ROUTE_ID = "routeId";
    public static final String MDC_TRANSACTION_KEY = "transactionKey";

    public MDCUnitOfWork(Exchange exchange) {
        super(exchange);
        MDC.put((String)MDC_EXCHANGE_ID, (String)exchange.getExchangeId());
        String corrId = exchange.getProperty("CamelCorrelationId", String.class);
        if (corrId != null) {
            MDC.put((String)MDC_CORRELATION_ID, (String)corrId);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        this.clear();
    }

    @Override
    public void pushRouteContext(RouteContext routeContext) {
        MDC.put((String)MDC_ROUTE_ID, (String)routeContext.getRoute().getId());
        super.pushRouteContext(routeContext);
    }

    @Override
    public RouteContext popRouteContext() {
        MDC.remove((String)MDC_ROUTE_ID);
        return super.popRouteContext();
    }

    @Override
    public void beginTransactedBy(Object key) {
        MDC.put((String)MDC_TRANSACTION_KEY, (String)key.toString());
        super.beginTransactedBy(key);
    }

    @Override
    public void endTransactedBy(Object key) {
        MDC.remove((String)MDC_TRANSACTION_KEY);
        super.endTransactedBy(key);
    }

    @Override
    public AsyncCallback beforeProcess(Processor processor, Exchange exchange, AsyncCallback callback) {
        return new MDCCallback(callback);
    }

    @Override
    public void afterProcess(Processor processor, Exchange exchange, AsyncCallback callback, boolean doneSync) {
        if (!doneSync) {
            this.clear();
        }
    }

    public void clear() {
        MDC.remove((String)MDC_EXCHANGE_ID);
        MDC.remove((String)MDC_CORRELATION_ID);
        MDC.remove((String)MDC_ROUTE_ID);
    }

    @Override
    public String toString() {
        return "MDCUnitOfWork";
    }

    private static final class MDCCallback
    implements AsyncCallback {
        private final AsyncCallback delegate;
        private final String exchangeId;
        private final String correlationId;
        private final String routeId;

        private MDCCallback(AsyncCallback delegate) {
            this.delegate = delegate;
            this.exchangeId = MDC.get((String)MDCUnitOfWork.MDC_EXCHANGE_ID);
            this.correlationId = MDC.get((String)MDCUnitOfWork.MDC_CORRELATION_ID);
            String routeId = MDC.get((String)MDCUnitOfWork.MDC_ROUTE_ID);
            this.routeId = routeId != null ? routeId.intern() : null;
        }

        @Override
        public void done(boolean doneSync) {
            if (!doneSync) {
                if (this.exchangeId != null) {
                    MDC.put((String)MDCUnitOfWork.MDC_EXCHANGE_ID, (String)this.exchangeId);
                }
                if (this.correlationId != null) {
                    MDC.put((String)MDCUnitOfWork.MDC_CORRELATION_ID, (String)this.correlationId);
                }
                if (this.routeId != null) {
                    MDC.put((String)MDCUnitOfWork.MDC_ROUTE_ID, (String)this.routeId);
                }
            }
            this.delegate.done(doneSync);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

