/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.processor.CamelLogger;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.AsyncProcessorHelper;

public class LogProcessor
implements AsyncProcessor,
Traceable {
    private final Expression expression;
    private final CamelLogger logger;

    public LogProcessor(Expression expression, CamelLogger logger) {
        this.expression = expression;
        this.logger = logger;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        String msg = this.expression.evaluate(exchange, String.class);
        this.logger.log(msg);
        return true;
    }

    public String toString() {
        return "Log[" + this.expression + "]";
    }

    @Override
    public String getTraceLabel() {
        return "log[" + this.expression + "]";
    }
}

