/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncProcessorHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(AsyncProcessorHelper.class);

    private AsyncProcessorHelper() {
    }

    public static boolean process(AsyncProcessor processor, Exchange exchange, AsyncCallback callback) {
        boolean sync;
        if (exchange.isTransacted()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Transacted Exchange must be routed synchronously for exchangeId: " + exchange.getExchangeId() + " -> " + exchange);
            }
            try {
                AsyncProcessorHelper.process(processor, exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            sync = true;
        } else {
            AsyncCallback async = callback;
            if (exchange.getUnitOfWork() != null) {
                async = exchange.getUnitOfWork().beforeProcess(processor, exchange, callback);
            }
            sync = processor.process(exchange, async);
            if (exchange.getUnitOfWork() != null) {
                exchange.getUnitOfWork().afterProcess(processor, exchange, callback, sync);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exchange processed and is continued routed " + (sync ? "synchronously" : "asynchronously") + " for exchangeId: " + exchange.getExchangeId() + " -> " + exchange);
        }
        return sync;
    }

    public static void process(final AsyncProcessor processor, final Exchange exchange) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        boolean sync = processor.process(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (!doneSync) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Asynchronous callback received for exchangeId: " + exchange.getExchangeId());
                    }
                    latch.countDown();
                }
            }

            public String toString() {
                return "Done " + processor;
            }
        });
        if (!sync) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Waiting for asynchronous callback before continuing for exchangeId: " + exchange.getExchangeId() + " -> " + exchange);
            }
            latch.await();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Asynchronous callback received, will continue routing exchangeId: " + exchange.getExchangeId() + " -> " + exchange);
            }
        }
    }

    @Deprecated
    public static Future<Exchange> asyncProcess(ExecutorService executor, final Processor processor, final Exchange exchange) {
        Callable<Exchange> task = new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                processor.process(exchange);
                return exchange;
            }
        };
        return executor.submit(task);
    }
}

