/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.NoSuchPropertyException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;

public final class ExchangeHelper {
    private ExchangeHelper() {
    }

    public static <T> T getBinding(Exchange exchange, Class<T> type) {
        return exchange != null ? (T)exchange.getProperty("CamelBinding", type) : null;
    }

    public static Endpoint resolveEndpoint(Exchange exchange, Object value) throws NoSuchEndpointException {
        Endpoint endpoint;
        if (value instanceof Endpoint) {
            endpoint = (Endpoint)value;
        } else {
            String uri = value.toString().trim();
            endpoint = CamelContextHelper.getMandatoryEndpoint(exchange.getContext(), uri);
        }
        return endpoint;
    }

    public static <T> T getMandatoryProperty(Exchange exchange, String propertyName, Class<T> type) throws NoSuchPropertyException {
        T result = exchange.getProperty(propertyName, type);
        if (result != null) {
            return result;
        }
        throw new NoSuchPropertyException(exchange, propertyName, type);
    }

    public static <T> T getMandatoryHeader(Exchange exchange, String propertyName, Class<T> type) throws NoSuchHeaderException {
        T answer = exchange.getIn().getHeader(propertyName, type);
        if (answer == null) {
            throw new NoSuchHeaderException(exchange, propertyName, type);
        }
        return answer;
    }

    public static Object getMandatoryInBody(Exchange exchange) throws InvalidPayloadException {
        return exchange.getIn().getMandatoryBody();
    }

    public static <T> T getMandatoryInBody(Exchange exchange, Class<T> type) throws InvalidPayloadException {
        return exchange.getIn().getMandatoryBody(type);
    }

    public static Object getMandatoryOutBody(Exchange exchange) throws InvalidPayloadException {
        return exchange.getOut().getMandatoryBody();
    }

    public static <T> T getMandatoryOutBody(Exchange exchange, Class<T> type) throws InvalidPayloadException {
        return exchange.getOut().getMandatoryBody(type);
    }

    public static <T> T convertToMandatoryType(Exchange exchange, Class<T> type, Object value) throws NoTypeConversionAvailableException {
        CamelContext camelContext = exchange.getContext();
        ObjectHelper.notNull(camelContext, "CamelContext of Exchange");
        TypeConverter converter = camelContext.getTypeConverter();
        if (converter != null) {
            return converter.mandatoryConvertTo(type, exchange, value);
        }
        throw new NoTypeConversionAvailableException(value, type);
    }

    public static <T> T convertToType(Exchange exchange, Class<T> type, Object value) {
        CamelContext camelContext = exchange.getContext();
        ObjectHelper.notNull(camelContext, "CamelContext of Exchange");
        TypeConverter converter = camelContext.getTypeConverter();
        if (converter != null) {
            return converter.convertTo(type, exchange, value);
        }
        return null;
    }

    public static Exchange createCorrelatedCopy(Exchange exchange, boolean handover) {
        String id = exchange.getExchangeId();
        Exchange copy = exchange.copy();
        copy.setUnitOfWork(null);
        UnitOfWork uow = exchange.getUnitOfWork();
        if (handover && uow != null) {
            uow.handoverSynchronization(copy);
        }
        copy.setProperty("CamelCorrelationId", id);
        return copy;
    }

    public static Exchange createCopy(Exchange exchange, boolean preserveExchangeId) {
        Exchange copy = exchange.copy();
        if (preserveExchangeId) {
            copy.setExchangeId(exchange.getExchangeId());
        }
        return copy;
    }

    public static void copyResults(Exchange result, Exchange source) {
        if (result != source) {
            result.setException(source.getException());
            if (source.hasOut()) {
                result.getOut().copyFrom(source.getOut());
            } else if (result.getPattern() == ExchangePattern.InOptionalOut) {
                result.setOut(null);
            } else if (result.getPattern().isOutCapable()) {
                result.getOut().copyFrom(source.getIn());
            } else {
                result.getIn().copyFrom(source.getIn());
                if (result.hasOut()) {
                    result.setOut(null);
                }
            }
            if (source.hasProperties()) {
                result.getProperties().putAll(source.getProperties());
            }
        }
    }

    public static void copyResultsPreservePattern(Exchange result, Exchange source) {
        if (source == result) {
            return;
        }
        result.getIn().copyFrom(source.getIn());
        if (source.hasOut()) {
            Message resultMessage = source.getOut().isFault() ? result.getOut() : ExchangeHelper.getResultMessage(result);
            resultMessage.copyFrom(source.getOut());
        }
        result.setException(source.getException());
        if (source.hasProperties()) {
            result.getProperties().putAll(source.getProperties());
        }
    }

    public static Message getResultMessage(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            return exchange.getOut();
        }
        return exchange.getIn();
    }

    public static boolean isOutCapable(Exchange exchange) {
        ExchangePattern pattern = exchange.getPattern();
        return pattern != null && pattern.isOutCapable();
    }

    public static <T> T newInstance(Exchange exchange, Class<T> type) {
        return exchange.getContext().getInjector().newInstance(type);
    }

    public static Map<String, Object> createVariableMap(Exchange exchange) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        ExchangeHelper.populateVariableMap(exchange, answer);
        return answer;
    }

    public static void populateVariableMap(Exchange exchange, Map<String, Object> map) {
        map.put("exchange", exchange);
        Message in = exchange.getIn();
        map.put("in", in);
        map.put("request", in);
        map.put("headers", in.getHeaders());
        map.put("body", in.getBody());
        if (ExchangeHelper.isOutCapable(exchange)) {
            Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
            map.put("out", msg);
            map.put("response", msg);
        }
        map.put("camelContext", exchange.getContext());
    }

    public static String getContentType(Exchange exchange) {
        return MessageHelper.getContentType(exchange.getIn());
    }

    public static String getContentEncoding(Exchange exchange) {
        return MessageHelper.getContentEncoding(exchange.getIn());
    }

    public static Object lookupMandatoryBean(Exchange exchange, String name) {
        Object value = ExchangeHelper.lookupBean(exchange, name);
        if (value == null) {
            throw new NoSuchBeanException(name);
        }
        return value;
    }

    public static <T> T lookupMandatoryBean(Exchange exchange, String name, Class<T> type) {
        T value = ExchangeHelper.lookupBean(exchange, name, type);
        if (value == null) {
            throw new NoSuchBeanException(name);
        }
        return value;
    }

    public static Object lookupBean(Exchange exchange, String name) {
        return exchange.getContext().getRegistry().lookup(name);
    }

    public static <T> T lookupBean(Exchange exchange, String name, Class<T> type) {
        return exchange.getContext().getRegistry().lookup(name, type);
    }

    public static Exchange getExchangeById(Iterable<Exchange> exchanges, String exchangeId) {
        for (Exchange exchange : exchanges) {
            String id = exchange.getExchangeId();
            if (id == null || !id.equals(exchangeId)) continue;
            return exchange;
        }
        return null;
    }

    public static void prepareAggregation(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange != null && oldExchange.hasOut()) {
            oldExchange.setIn(oldExchange.getOut());
            oldExchange.setOut(null);
        }
        if (newExchange != null && newExchange.hasOut()) {
            newExchange.setIn(newExchange.getOut());
            newExchange.setOut(null);
        }
    }

    public static boolean isFailureHandled(Exchange exchange) {
        return exchange.getProperty("CamelFailureHandled", false, Boolean.class);
    }

    public static void setFailureHandled(Exchange exchange) {
        exchange.setProperty("CamelFailureHandled", Boolean.TRUE);
        exchange.setException(null);
    }

    public static boolean isRedeliveryExhausted(Exchange exchange) {
        return exchange.getProperty("CamelRedeliveryExhausted", false, Boolean.class);
    }

    public static boolean isInterrupted(Exchange exchange) {
        return exchange.getException(InterruptedException.class) != null;
    }

    public static Object extractResultBody(Exchange exchange, ExchangePattern pattern) {
        Object answer = null;
        if (exchange != null) {
            if (exchange.getException() != null) {
                throw ObjectHelper.wrapCamelExecutionException(exchange, exchange.getException());
            }
            if (ExchangeHelper.hasFaultMessage(exchange)) {
                return exchange.getOut().getBody();
            }
            boolean notOut = pattern != null && !pattern.isOutCapable();
            boolean hasOut = exchange.hasOut();
            answer = hasOut && !notOut ? exchange.getOut().getBody() : (!hasOut && exchange.getPattern() == ExchangePattern.InOptionalOut ? null : exchange.getIn().getBody());
        }
        return answer;
    }

    public static boolean hasFaultMessage(Exchange exchange) {
        return exchange.hasOut() && exchange.getOut().isFault() && exchange.getOut().getBody() != null;
    }

    public static boolean hasExceptionBeenHandledByErrorHandler(Exchange exchange) {
        return Boolean.TRUE.equals(exchange.getProperty("CamelErrorHandlerHandled"));
    }

    public static <T> T extractFutureBody(CamelContext context, Future<Object> future, Class<T> type) {
        try {
            T t = ExchangeHelper.doExtractFutureBody(context, future.get(), type);
            return t;
        }
        catch (InterruptedException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        catch (ExecutionException e) {
            throw ObjectHelper.wrapCamelExecutionException(null, e.getCause());
        }
        finally {
            future.cancel(true);
        }
    }

    public static <T> T extractFutureBody(CamelContext context, Future<Object> future, long timeout, TimeUnit unit, Class<T> type) throws TimeoutException {
        try {
            if (timeout > 0L) {
                T t = ExchangeHelper.doExtractFutureBody(context, future.get(timeout, unit), type);
                return t;
            }
            T t = ExchangeHelper.doExtractFutureBody(context, future.get(), type);
            return t;
        }
        catch (InterruptedException e) {
            throw ObjectHelper.wrapCamelExecutionException(null, e);
        }
        catch (ExecutionException e) {
            throw ObjectHelper.wrapCamelExecutionException(null, e.getCause());
        }
        finally {
            future.cancel(true);
        }
    }

    private static <T> T doExtractFutureBody(CamelContext context, Object result, Class<T> type) {
        if (result == null) {
            return null;
        }
        if (type.isAssignableFrom(result.getClass())) {
            return type.cast(result);
        }
        if (result instanceof Exchange) {
            Exchange exchange = (Exchange)result;
            Object answer = ExchangeHelper.extractResultBody(exchange, exchange.getPattern());
            return context.getTypeConverter().convertTo(type, answer);
        }
        return context.getTypeConverter().convertTo(type, result);
    }

    public static String createExceptionMessage(String message, Exchange exchange, Throwable cause) {
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            sb.append(message);
        }
        if (exchange != null) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append(exchange);
        }
        if (cause != null) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append("Caused by: [" + cause.getClass().getName() + " - " + cause.getMessage() + "]");
        }
        return sb.toString().trim();
    }

    public static void prepareOutToIn(Exchange exchange) {
        if (exchange.hasOut()) {
            exchange.getIn().copyFrom(exchange.getOut());
            exchange.setOut(null);
        }
    }
}

