/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.AdviceWithTasks;
import org.apache.camel.model.PipelineDefinition;
import org.apache.camel.model.ProcessorDefinition;

public class AdviceWithBuilder {
    private final AdviceWithRouteBuilder builder;
    private final String id;
    private final String toString;

    public AdviceWithBuilder(AdviceWithRouteBuilder builder, String id, String toString) {
        this.builder = builder;
        this.id = id;
        this.toString = toString;
        if (id == null && toString == null) {
            throw new IllegalArgumentException("Either id or toString must be specified");
        }
    }

    public ProcessorDefinition replace() {
        PipelineDefinition answer = new PipelineDefinition();
        if (this.id != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.replaceById(this.builder.getOriginalRoute(), this.id, answer));
        } else if (this.toString != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.replaceByToString(this.builder.getOriginalRoute(), this.toString, answer));
        }
        return answer;
    }

    public void remove() {
        if (this.id != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.removeById(this.builder.getOriginalRoute(), this.id));
        } else if (this.toString != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.removeByToString(this.builder.getOriginalRoute(), this.toString));
        }
    }

    public ProcessorDefinition before() {
        PipelineDefinition answer = new PipelineDefinition();
        if (this.id != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.beforeById(this.builder.getOriginalRoute(), this.id, answer));
        } else if (this.toString != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.beforeByToString(this.builder.getOriginalRoute(), this.toString, answer));
        }
        return answer;
    }

    public ProcessorDefinition after() {
        PipelineDefinition answer = new PipelineDefinition();
        if (this.id != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.afterById(this.builder.getOriginalRoute(), this.id, answer));
        } else if (this.toString != null) {
            this.builder.getAdviceWithTasks().add(AdviceWithTasks.afterByToString(this.builder.getOriginalRoute(), this.toString, answer));
        }
        return answer;
    }
}

