/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.dataformat.BindyDataFormat;
import org.apache.camel.model.dataformat.BindyType;
import org.apache.camel.model.dataformat.CastorDataFormat;
import org.apache.camel.model.dataformat.CsvDataFormat;
import org.apache.camel.model.dataformat.GzipDataFormat;
import org.apache.camel.model.dataformat.HL7DataFormat;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.model.dataformat.JibxDataFormat;
import org.apache.camel.model.dataformat.JsonDataFormat;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.model.dataformat.ProtobufDataFormat;
import org.apache.camel.model.dataformat.RssDataFormat;
import org.apache.camel.model.dataformat.SerializationDataFormat;
import org.apache.camel.model.dataformat.SoapJaxbDataFormat;
import org.apache.camel.model.dataformat.StringDataFormat;
import org.apache.camel.model.dataformat.SyslogDataFormat;
import org.apache.camel.model.dataformat.TidyMarkupDataFormat;
import org.apache.camel.model.dataformat.XMLBeansDataFormat;
import org.apache.camel.model.dataformat.XMLSecurityDataFormat;
import org.apache.camel.model.dataformat.XStreamDataFormat;
import org.apache.camel.model.dataformat.ZipDataFormat;
import org.w3c.dom.Node;

public class DataFormatClause<T extends ProcessorDefinition<?>> {
    private final T processorType;
    private final Operation operation;

    public DataFormatClause(T processorType, Operation operation) {
        this.processorType = processorType;
        this.operation = operation;
    }

    public T bindy(BindyType type, String ... packages) {
        BindyDataFormat bindy = new BindyDataFormat();
        bindy.setType(type);
        bindy.setPackages(packages);
        return this.dataFormat(bindy);
    }

    public T csv() {
        return this.dataFormat(new CsvDataFormat());
    }

    public T castor() {
        return this.dataFormat(new CastorDataFormat());
    }

    public T castor(String mappingFile) {
        CastorDataFormat castor = new CastorDataFormat();
        castor.setMappingFile(mappingFile);
        return this.dataFormat(castor);
    }

    public T castor(String mappingFile, boolean validation) {
        CastorDataFormat castor = new CastorDataFormat();
        castor.setMappingFile(mappingFile);
        castor.setValidation(validation);
        return this.dataFormat(castor);
    }

    public T gzip() {
        GzipDataFormat gzdf = new GzipDataFormat();
        return this.dataFormat(gzdf);
    }

    public T hl7() {
        return this.dataFormat(new HL7DataFormat());
    }

    public T hl7(boolean validate) {
        HL7DataFormat hl7 = new HL7DataFormat();
        hl7.setValidate(validate);
        return this.dataFormat(hl7);
    }

    public T jaxb() {
        return this.dataFormat(new JaxbDataFormat());
    }

    public T jaxb(String contextPath) {
        JaxbDataFormat dataFormat = new JaxbDataFormat();
        dataFormat.setContextPath(contextPath);
        return this.dataFormat(dataFormat);
    }

    public T jaxb(boolean prettyPrint) {
        return this.dataFormat(new JaxbDataFormat(prettyPrint));
    }

    public T jibx() {
        return this.dataFormat(new JibxDataFormat());
    }

    public T jibx(Class unmarshallClass) {
        return this.dataFormat(new JibxDataFormat(unmarshallClass));
    }

    public T json() {
        return this.dataFormat(new JsonDataFormat());
    }

    public T json(JsonLibrary library) {
        return this.dataFormat(new JsonDataFormat(library));
    }

    public T json(JsonLibrary type, Class<?> unmarshalType) {
        JsonDataFormat json = new JsonDataFormat(type);
        json.setUnmarshalType(unmarshalType);
        return this.dataFormat(json);
    }

    public T protobuf() {
        return this.dataFormat(new ProtobufDataFormat());
    }

    public T protobuf(Object defaultInstance) {
        ProtobufDataFormat dataFormat = new ProtobufDataFormat();
        dataFormat.setDefaultInstance(defaultInstance);
        return this.dataFormat(dataFormat);
    }

    public T protobuf(String instanceClassName) {
        return this.dataFormat(new ProtobufDataFormat(instanceClassName));
    }

    public T rss() {
        return this.dataFormat(new RssDataFormat());
    }

    public T serialization() {
        return this.dataFormat(new SerializationDataFormat());
    }

    public T soapjaxb() {
        return this.dataFormat(new SoapJaxbDataFormat());
    }

    public T soapjaxb(String contextPath) {
        return this.dataFormat(new SoapJaxbDataFormat(contextPath));
    }

    public T soapjaxb(String contextPath, String elementNameStrategyRef) {
        return this.dataFormat(new SoapJaxbDataFormat(contextPath, elementNameStrategyRef));
    }

    public T soapjaxb(String contextPath, Object elementNameStrategy) {
        return this.dataFormat(new SoapJaxbDataFormat(contextPath, elementNameStrategy));
    }

    public T string() {
        return this.string(null);
    }

    public T string(String charset) {
        StringDataFormat sdf = new StringDataFormat();
        sdf.setCharset(charset);
        return this.dataFormat(sdf);
    }

    public T syslog() {
        return this.dataFormat(new SyslogDataFormat());
    }

    public T tidyMarkup(Class<?> dataObjectType) {
        return this.dataFormat(new TidyMarkupDataFormat(dataObjectType));
    }

    public T tidyMarkup() {
        return this.dataFormat(new TidyMarkupDataFormat(Node.class));
    }

    public T xstream() {
        return this.dataFormat(new XStreamDataFormat());
    }

    public T xstream(String encoding) {
        return this.dataFormat(new XStreamDataFormat(encoding));
    }

    public T secureXML() {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, boolean secureTagContents) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, secureTagContents);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, boolean secureTagContents, String passPhrase) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, secureTagContents, passPhrase);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, boolean secureTagContents, String passPhrase, String xmlCipherAlgorithm) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, secureTagContents, passPhrase, xmlCipherAlgorithm);
        return this.dataFormat(xsdf);
    }

    public T xmlBeans() {
        return this.dataFormat(new XMLBeansDataFormat());
    }

    public T zip() {
        ZipDataFormat zdf = new ZipDataFormat(-1);
        return this.dataFormat(zdf);
    }

    public T zip(int compressionLevel) {
        ZipDataFormat zdf = new ZipDataFormat(compressionLevel);
        return this.dataFormat(zdf);
    }

    private T dataFormat(DataFormatDefinition dataFormatType) {
        switch (this.operation) {
            case Unmarshal: {
                return (T)((ProcessorDefinition)this.processorType).unmarshal(dataFormatType);
            }
            case Marshal: {
                return (T)((ProcessorDefinition)this.processorType).marshal(dataFormatType);
            }
        }
        throw new IllegalArgumentException("Unknown DataFormat operation: " + (Object)((Object)this.operation));
    }

    public static enum Operation {
        Marshal,
        Unmarshal;

    }
}

