/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;

public abstract class ErrorHandlerBuilderSupport
implements ErrorHandlerBuilder {
    private List<OnExceptionDefinition> exceptions = new ArrayList<OnExceptionDefinition>();
    private ExceptionPolicyStrategy exceptionPolicyStrategy = ErrorHandlerSupport.createDefaultExceptionPolicyStrategy();

    @Override
    public void addErrorHandlers(OnExceptionDefinition exception) {
        if (!this.exceptions.contains(exception)) {
            this.exceptions.add(exception);
        }
    }

    @Override
    public void configure(ErrorHandler handler) {
        if (handler instanceof ErrorHandlerSupport) {
            ErrorHandlerSupport handlerSupport = (ErrorHandlerSupport)handler;
            for (OnExceptionDefinition exception : this.exceptions) {
                handlerSupport.addExceptionPolicy(exception);
            }
        }
    }

    @Override
    public List<OnExceptionDefinition> getErrorHandlers() {
        return this.exceptions;
    }

    @Override
    public void setErrorHandlers(List<OnExceptionDefinition> exceptions) {
        this.exceptions.clear();
        this.exceptions.addAll(exceptions);
    }

    public ErrorHandlerBuilderSupport exceptionPolicyStrategy(ExceptionPolicyStrategy exceptionPolicyStrategy) {
        this.setExceptionPolicyStrategy(exceptionPolicyStrategy);
        return this;
    }

    @Override
    public ExceptionPolicyStrategy getExceptionPolicyStrategy() {
        return this.exceptionPolicyStrategy;
    }

    @Override
    public void setExceptionPolicyStrategy(ExceptionPolicyStrategy exceptionPolicyStrategy) {
        this.exceptionPolicyStrategy = exceptionPolicyStrategy;
    }
}

