/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Producer;
import org.apache.camel.builder.ExpressionClauseSupport;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.EventNotifierSupport;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.management.event.ExchangeCreatedEvent;
import org.apache.camel.management.event.ExchangeFailedEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class NotifyBuilder {
    private final CamelContext context;
    private final EventNotifier eventNotifier;
    private final List<EventPredicateHolder> predicates = new ArrayList<EventPredicateHolder>();
    private CountDownLatch latch = new CountDownLatch(1);
    private final Stack<EventPredicate> stack = new Stack();
    private EventOperation operation;
    private boolean created;
    private boolean matches;

    public NotifyBuilder(CamelContext context) {
        this.context = context;
        this.eventNotifier = new ExchangeNotifier();
        try {
            ServiceHelper.startService(this.eventNotifier);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        context.getManagementStrategy().addEventNotifier(this.eventNotifier);
        this.fromRoutesOnly();
    }

    public NotifyBuilder from(final String endpointUri) {
        this.stack.push(new EventPredicateSupport(){

            @Override
            public boolean onExchange(Exchange exchange) {
                return EndpointHelper.matchEndpoint(exchange.getFromEndpoint().getEndpointUri(), endpointUri);
            }

            @Override
            public boolean matches() {
                return true;
            }

            public String toString() {
                return "from(" + endpointUri + ")";
            }
        });
        return this;
    }

    public NotifyBuilder fromRoute(final String routeId) {
        this.stack.push(new EventPredicateSupport(){

            @Override
            public boolean onExchange(Exchange exchange) {
                String id = EndpointHelper.getRouteIdFromEndpoint(exchange.getFromEndpoint());
                return EndpointHelper.matchPattern(id, routeId);
            }

            @Override
            public boolean matches() {
                return true;
            }

            public String toString() {
                return "fromRoute(" + routeId + ")";
            }
        });
        return this;
    }

    private NotifyBuilder fromRoutesOnly() {
        this.stack.push(new EventPredicateSupport(){

            @Override
            public boolean onExchange(Exchange exchange) {
                if (exchange.getFromEndpoint() != null && exchange.getFromEndpoint() instanceof DirectEndpoint) {
                    return true;
                }
                return EndpointHelper.matchPattern(exchange.getFromRouteId(), "*");
            }

            @Override
            public boolean matches() {
                return true;
            }

            public String toString() {
                return "";
            }
        });
        return this;
    }

    public NotifyBuilder filter(final Predicate predicate) {
        this.stack.push(new EventPredicateSupport(){

            @Override
            public boolean onExchange(Exchange exchange) {
                return predicate.matches(exchange);
            }

            @Override
            public boolean matches() {
                return true;
            }

            public String toString() {
                return "filter(" + predicate + ")";
            }
        });
        return this;
    }

    public ExpressionClauseSupport<NotifyBuilder> filter() {
        final ExpressionClauseSupport<NotifyBuilder> clause = new ExpressionClauseSupport<NotifyBuilder>(this);
        this.stack.push(new EventPredicateSupport(){

            @Override
            public boolean onExchange(Exchange exchange) {
                Expression exp = clause.createExpression(exchange.getContext());
                return exp.evaluate(exchange, Boolean.class);
            }

            @Override
            public boolean matches() {
                return true;
            }

            public String toString() {
                return "filter(" + clause + ")";
            }
        });
        return clause;
    }

    public NotifyBuilder whenReceived(final int number) {
        this.stack.push(new EventPredicateSupport(){
            private int current;

            @Override
            public boolean onExchangeCreated(Exchange exchange) {
                ++this.current;
                return true;
            }

            @Override
            public boolean matches() {
                return this.current >= number;
            }

            @Override
            public void reset() {
                this.current = 0;
            }

            public String toString() {
                return "whenReceived(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenDone(final int number) {
        this.stack.add(new EventPredicateSupport(){
            private int current;

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                ++this.current;
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                ++this.current;
                return true;
            }

            @Override
            public boolean matches() {
                return this.current >= number;
            }

            @Override
            public void reset() {
                this.current = 0;
            }

            public String toString() {
                return "whenDone(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenCompleted(final int number) {
        this.stack.add(new EventPredicateSupport(){
            private int current;

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                ++this.current;
                return true;
            }

            @Override
            public boolean matches() {
                return this.current >= number;
            }

            @Override
            public void reset() {
                this.current = 0;
            }

            public String toString() {
                return "whenCompleted(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenFailed(final int number) {
        this.stack.add(new EventPredicateSupport(){
            private int current;

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                ++this.current;
                return true;
            }

            @Override
            public boolean matches() {
                return this.current >= number;
            }

            @Override
            public void reset() {
                this.current = 0;
            }

            public String toString() {
                return "whenFailed(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenExactlyDone(final int number) {
        this.stack.add(new EventPredicateSupport(){
            private int current;

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                ++this.current;
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                ++this.current;
                return true;
            }

            @Override
            public boolean matches() {
                return this.current == number;
            }

            @Override
            public void reset() {
                this.current = 0;
            }

            public String toString() {
                return "whenExactlyDone(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenExactlyCompleted(final int number) {
        this.stack.add(new EventPredicateSupport(){
            private int current;

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                ++this.current;
                return true;
            }

            @Override
            public boolean matches() {
                return this.current == number;
            }

            @Override
            public void reset() {
                this.current = 0;
            }

            public String toString() {
                return "whenExactlyCompleted(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenExactlyFailed(final int number) {
        this.stack.add(new EventPredicateSupport(){
            private int current;

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                ++this.current;
                return true;
            }

            @Override
            public boolean matches() {
                return this.current == number;
            }

            @Override
            public void reset() {
                this.current = 0;
            }

            public String toString() {
                return "whenExactlyFailed(" + number + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenAnyReceivedMatches(Predicate predicate) {
        return this.doWhenAnyMatches(predicate, true);
    }

    public NotifyBuilder whenAnyDoneMatches(Predicate predicate) {
        return this.doWhenAnyMatches(predicate, false);
    }

    private NotifyBuilder doWhenAnyMatches(final Predicate predicate, final boolean received) {
        this.stack.push(new EventPredicateSupport(){
            private boolean matches;

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                if (!received && !this.matches) {
                    this.matches = predicate.matches(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                if (!received && !this.matches) {
                    this.matches = predicate.matches(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeCreated(Exchange exchange) {
                if (received && !this.matches) {
                    this.matches = predicate.matches(exchange);
                }
                return true;
            }

            @Override
            public boolean matches() {
                return this.matches;
            }

            @Override
            public void reset() {
                this.matches = false;
            }

            public String toString() {
                if (received) {
                    return "whenAnyReceivedMatches(" + predicate + ")";
                }
                return "whenAnyDoneMatches(" + predicate + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenAllReceivedMatches(Predicate predicate) {
        return this.doWhenAllMatches(predicate, true);
    }

    public NotifyBuilder whenAllDoneMatches(Predicate predicate) {
        return this.doWhenAllMatches(predicate, false);
    }

    private NotifyBuilder doWhenAllMatches(final Predicate predicate, final boolean received) {
        this.stack.push(new EventPredicateSupport(){
            private boolean matches = true;

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                if (!received && this.matches) {
                    this.matches = predicate.matches(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                if (!received && this.matches) {
                    this.matches = predicate.matches(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeCreated(Exchange exchange) {
                if (received && this.matches) {
                    this.matches = predicate.matches(exchange);
                }
                return true;
            }

            @Override
            public boolean matches() {
                return this.matches;
            }

            @Override
            public void reset() {
                this.matches = true;
            }

            public String toString() {
                if (received) {
                    return "whenAllReceivedMatches(" + predicate + ")";
                }
                return "whenAllDoneMatches(" + predicate + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenDoneSatisfied(MockEndpoint mock) {
        return this.doWhenSatisfied(mock, false);
    }

    public NotifyBuilder whenReceivedSatisfied(MockEndpoint mock) {
        return this.doWhenSatisfied(mock, true);
    }

    private NotifyBuilder doWhenSatisfied(final MockEndpoint mock, final boolean received) {
        this.stack.push(new EventPredicateSupport(){
            private Producer producer;

            @Override
            public boolean onExchangeCreated(Exchange exchange) {
                if (received) {
                    this.sendToMock(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                if (!received) {
                    this.sendToMock(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                if (!received) {
                    this.sendToMock(exchange);
                }
                return true;
            }

            private void sendToMock(Exchange exchange) {
                try {
                    if (this.producer == null) {
                        this.producer = mock.createProducer();
                    }
                    this.producer.process(exchange);
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }

            @Override
            public boolean matches() {
                try {
                    return mock.await(0L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }

            @Override
            public void reset() {
                mock.reset();
            }

            public String toString() {
                if (received) {
                    return "whenReceivedSatisfied(" + mock + ")";
                }
                return "whenDoneSatisfied(" + mock + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenReceivedNotSatisfied(MockEndpoint mock) {
        return this.doWhenNotSatisfied(mock, true);
    }

    public NotifyBuilder whenDoneNotSatisfied(MockEndpoint mock) {
        return this.doWhenNotSatisfied(mock, false);
    }

    private NotifyBuilder doWhenNotSatisfied(final MockEndpoint mock, final boolean received) {
        this.stack.push(new EventPredicateSupport(){
            private Producer producer;

            @Override
            public boolean onExchangeCreated(Exchange exchange) {
                if (received) {
                    this.sendToMock(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                if (!received) {
                    this.sendToMock(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                if (!received) {
                    this.sendToMock(exchange);
                }
                return true;
            }

            private void sendToMock(Exchange exchange) {
                try {
                    if (this.producer == null) {
                        this.producer = mock.createProducer();
                    }
                    this.producer.process(exchange);
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }

            @Override
            public boolean matches() {
                try {
                    return !mock.await(0L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }

            @Override
            public void reset() {
                mock.reset();
            }

            public String toString() {
                if (received) {
                    return "whenReceivedNotSatisfied(" + mock + ")";
                }
                return "whenDoneNotSatisfied(" + mock + ")";
            }
        });
        return this;
    }

    public NotifyBuilder whenBodiesReceived(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        bodyList.addAll(Arrays.asList(bodies));
        return this.doWhenBodies(bodyList, true, false);
    }

    public NotifyBuilder whenBodiesDone(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        bodyList.addAll(Arrays.asList(bodies));
        return this.doWhenBodies(bodyList, false, false);
    }

    public NotifyBuilder whenExactBodiesReceived(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        bodyList.addAll(Arrays.asList(bodies));
        return this.doWhenBodies(bodyList, true, true);
    }

    public NotifyBuilder whenExactBodiesDone(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        bodyList.addAll(Arrays.asList(bodies));
        return this.doWhenBodies(bodyList, false, true);
    }

    private NotifyBuilder doWhenBodies(final List bodies, final boolean received, final boolean exact) {
        this.stack.push(new EventPredicateSupport(){
            private boolean matches;
            private int current;

            @Override
            public boolean onExchangeCreated(Exchange exchange) {
                if (received) {
                    this.matchBody(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeFailed(Exchange exchange) {
                if (!received) {
                    this.matchBody(exchange);
                }
                return true;
            }

            @Override
            public boolean onExchangeCompleted(Exchange exchange) {
                if (!received) {
                    this.matchBody(exchange);
                }
                return true;
            }

            private void matchBody(Exchange exchange) {
                ++this.current;
                if (this.current > bodies.size()) {
                    return;
                }
                Object actual = exchange.getIn().getBody();
                Object expected = bodies.get(this.current - 1);
                this.matches = ObjectHelper.equal(expected, actual);
            }

            @Override
            public boolean matches() {
                if (exact) {
                    return this.matches && this.current == bodies.size();
                }
                return this.matches && this.current >= bodies.size();
            }

            @Override
            public void reset() {
                this.matches = false;
                this.current = 0;
            }

            public String toString() {
                if (received) {
                    return "" + (exact ? "whenExactBodiesReceived(" : "whenBodiesReceived(") + bodies + ")";
                }
                return "" + (exact ? "whenExactBodiesDone(" : "whenBodiesDone(") + bodies + ")";
            }
        });
        return this;
    }

    public NotifyBuilder and() {
        this.doCreate(EventOperation.and);
        return this;
    }

    public NotifyBuilder or() {
        this.doCreate(EventOperation.or);
        return this;
    }

    public NotifyBuilder not() {
        this.doCreate(EventOperation.not);
        return this;
    }

    public NotifyBuilder create() {
        this.doCreate(EventOperation.and);
        this.created = true;
        return this;
    }

    public boolean matches() {
        if (!this.created) {
            throw new IllegalStateException("NotifyBuilder has not been created. Invoke the create() method before matching.");
        }
        return this.matches;
    }

    public boolean matches(long timeout, TimeUnit timeUnit) {
        if (!this.created) {
            throw new IllegalStateException("NotifyBuilder has not been created. Invoke the create() method before matching.");
        }
        try {
            this.latch.await(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return this.matches();
    }

    public boolean matchesMockWaitTime() {
        if (!this.created) {
            throw new IllegalStateException("NotifyBuilder has not been created. Invoke the create() method before matching.");
        }
        long timeout = 0L;
        for (Endpoint endpoint : this.context.getEndpoints()) {
            long waitTime;
            if (!(endpoint instanceof MockEndpoint) || (waitTime = ((MockEndpoint)endpoint).getResultWaitTime()) <= 0L) continue;
            timeout = Math.max(timeout, waitTime);
        }
        if (timeout == 0L) {
            timeout = 10000L;
        }
        return this.matches(timeout, TimeUnit.MILLISECONDS);
    }

    public void reset() {
        for (EventPredicateHolder predicate : this.predicates) {
            predicate.reset();
        }
        this.latch = new CountDownLatch(1);
        this.matches = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<EventPredicateHolder> it = this.predicates.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(it.next().toString());
        }
        return ObjectHelper.after(sb.toString(), "().");
    }

    private void doCreate(EventOperation newOperation) {
        if (this.operation == null) {
            EventOperation eventOperation = this.operation = newOperation == EventOperation.or ? EventOperation.or : EventOperation.and;
        }
        if (!this.stack.isEmpty()) {
            CompoundEventPredicate compound = new CompoundEventPredicate(this.stack);
            this.stack.clear();
            this.predicates.add(new EventPredicateHolder(this.operation, compound));
        }
        this.operation = newOperation;
    }

    private final class CompoundEventPredicate
    implements EventPredicate {
        private List<EventPredicate> predicates = new ArrayList<EventPredicate>();

        private CompoundEventPredicate(Stack<EventPredicate> predicates) {
            this.predicates.addAll(predicates);
        }

        @Override
        public boolean matches() {
            for (EventPredicate predicate : this.predicates) {
                if (predicate.matches()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void reset() {
            for (EventPredicate predicate : this.predicates) {
                predicate.reset();
            }
        }

        @Override
        public boolean onExchangeCreated(Exchange exchange) {
            for (EventPredicate predicate : this.predicates) {
                if (predicate.onExchangeCreated(exchange)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean onExchangeCompleted(Exchange exchange) {
            for (EventPredicate predicate : this.predicates) {
                if (predicate.onExchangeCompleted(exchange)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean onExchangeFailed(Exchange exchange) {
            for (EventPredicate predicate : this.predicates) {
                if (predicate.onExchangeFailed(exchange)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<EventPredicate> it = this.predicates.iterator();
            while (it.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(".");
                }
                sb.append(it.next().toString());
            }
            return sb.toString();
        }
    }

    private final class EventPredicateHolder {
        private final EventOperation operation;
        private final EventPredicate predicate;

        private EventPredicateHolder(EventOperation operation, EventPredicate predicate) {
            this.operation = operation;
            this.predicate = predicate;
        }

        public EventOperation getOperation() {
            return this.operation;
        }

        public EventPredicate getPredicate() {
            return this.predicate;
        }

        public void reset() {
            this.predicate.reset();
        }

        public String toString() {
            return this.operation.name() + "()." + this.predicate;
        }
    }

    private abstract class EventPredicateSupport
    implements EventPredicate {
        private EventPredicateSupport() {
        }

        @Override
        public void reset() {
        }

        @Override
        public boolean onExchangeCreated(Exchange exchange) {
            return this.onExchange(exchange);
        }

        @Override
        public boolean onExchangeCompleted(Exchange exchange) {
            return this.onExchange(exchange);
        }

        @Override
        public boolean onExchangeFailed(Exchange exchange) {
            return this.onExchange(exchange);
        }

        public boolean onExchange(Exchange exchange) {
            return true;
        }
    }

    private static interface EventPredicate {
        public boolean matches();

        public void reset();

        public boolean onExchangeCreated(Exchange var1);

        public boolean onExchangeCompleted(Exchange var1);

        public boolean onExchangeFailed(Exchange var1);
    }

    private static enum EventOperation {
        and,
        or,
        not;

    }

    private final class ExchangeNotifier
    extends EventNotifierSupport {
        private ExchangeNotifier() {
        }

        @Override
        public void notify(EventObject event) throws Exception {
            if (event instanceof ExchangeCreatedEvent) {
                this.onExchangeCreated((ExchangeCreatedEvent)event);
            } else if (event instanceof ExchangeCompletedEvent) {
                this.onExchangeCompleted((ExchangeCompletedEvent)event);
            } else if (event instanceof ExchangeFailedEvent) {
                this.onExchangeFailed((ExchangeFailedEvent)event);
            }
            this.computeMatches();
        }

        @Override
        public boolean isEnabled(EventObject event) {
            return true;
        }

        private void onExchangeCreated(ExchangeCreatedEvent event) {
            for (EventPredicateHolder predicate : NotifyBuilder.this.predicates) {
                predicate.getPredicate().onExchangeCreated(event.getExchange());
            }
        }

        private void onExchangeCompleted(ExchangeCompletedEvent event) {
            for (EventPredicateHolder predicate : NotifyBuilder.this.predicates) {
                predicate.getPredicate().onExchangeCompleted(event.getExchange());
            }
        }

        private void onExchangeFailed(ExchangeFailedEvent event) {
            for (EventPredicateHolder predicate : NotifyBuilder.this.predicates) {
                predicate.getPredicate().onExchangeFailed(event.getExchange());
            }
        }

        private synchronized void computeMatches() {
            Boolean answer = null;
            for (EventPredicateHolder holder : NotifyBuilder.this.predicates) {
                EventOperation operation = holder.getOperation();
                if (EventOperation.and == operation) {
                    if (holder.getPredicate().matches()) {
                        answer = true;
                        continue;
                    }
                    answer = false;
                    break;
                }
                if (EventOperation.or == operation) {
                    if (!holder.getPredicate().matches()) continue;
                    answer = true;
                    continue;
                }
                if (EventOperation.not != operation) continue;
                if (holder.getPredicate().matches()) {
                    answer = false;
                    break;
                }
                answer = true;
            }
            if (answer != null) {
                NotifyBuilder.this.matches = answer;
                if (NotifyBuilder.this.matches) {
                    NotifyBuilder.this.latch.countDown();
                }
            }
        }

        @Override
        protected void doStart() throws Exception {
            this.setIgnoreCamelContextEvents(true);
            this.setIgnoreRouteEvents(true);
            this.setIgnoreServiceEvents(true);
        }

        @Override
        protected void doStop() throws Exception {
        }
    }
}

