/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanProcessor
extends ServiceSupport
implements AsyncProcessor {
    private static final transient Logger LOG = LoggerFactory.getLogger(BeanProcessor.class);
    private boolean multiParameterArray;
    private Method methodObject;
    private String method;
    private BeanHolder beanHolder;
    private boolean shorthandMethod;

    public BeanProcessor(Object pojo, BeanInfo beanInfo) {
        this(new ConstantBeanHolder(pojo, beanInfo));
    }

    public BeanProcessor(Object pojo, CamelContext camelContext, ParameterMappingStrategy parameterMappingStrategy) {
        this(pojo, new BeanInfo(camelContext, pojo.getClass(), parameterMappingStrategy));
    }

    public BeanProcessor(Object pojo, CamelContext camelContext) {
        this(pojo, camelContext, BeanInfo.createParameterMappingStrategy(camelContext));
    }

    public BeanProcessor(BeanHolder beanHolder) {
        this.beanHolder = beanHolder;
    }

    public String toString() {
        String description = this.methodObject != null ? " " + this.methodObject : "";
        return "BeanProcessor[" + this.beanHolder + description + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        MethodInvocation invocation;
        BeanInfo beanInfo;
        Object bean;
        boolean isExplicitMethod = ObjectHelper.isNotEmpty(this.method);
        try {
            bean = this.beanHolder.getBean();
            beanInfo = this.beanHolder.getBeanInfo();
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        Processor processor = this.getProcessor();
        if (!isExplicitMethod && processor != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Using a custom adapter as bean invocation: " + processor);
            }
            try {
                processor.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
        Message in = exchange.getIn();
        BeanInvocation beanInvoke = in.getBody(BeanInvocation.class);
        if (beanInvoke != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Exchange IN body is a BeanInvocation instance: " + beanInvoke);
            }
            Class<?> clazz = beanInvoke.getMethod().getDeclaringClass();
            boolean sameBean = clazz.isInstance(bean);
            if (LOG.isTraceEnabled()) {
                LOG.debug("BeanHolder bean: " + bean.getClass() + " and beanInvocation bean: " + clazz + " is same instance: " + sameBean);
            }
            if (sameBean) {
                beanInvoke.invoke(bean, exchange);
                exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
                callback.done(true);
                return true;
            }
        }
        if (in.getHeader("CamelBeanMultiParameterArray") == null) {
            in.setHeader("CamelBeanMultiParameterArray", this.isMultiParameterArray());
        }
        String prevMethod = null;
        if (this.methodObject != null) {
            invocation = beanInfo.createInvocation(this.methodObject, bean, exchange);
        } else {
            if (isExplicitMethod) {
                prevMethod = in.getHeader("CamelBeanMethodName", String.class);
                in.setHeader("CamelBeanMethodName", this.method);
            }
            try {
                invocation = beanInfo.createInvocation(bean, exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
                callback.done(true);
                return true;
            }
        }
        if (invocation == null) {
            throw new IllegalStateException("No method invocation could be created, no matching method could be found on: " + bean);
        }
        in.removeHeader("CamelBeanMultiParameterArray");
        Object value = null;
        try {
            AtomicBoolean sync = new AtomicBoolean(true);
            value = invocation.proceed(callback, sync);
            if (!sync.get()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed asynchronously");
                }
                boolean bl = false;
                return bl;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed synchronously");
            }
        }
        catch (InvocationTargetException e) {
            exchange.setException(e.getCause());
            callback.done(true);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            boolean bl = true;
            return bl;
        }
        finally {
            if (isExplicitMethod) {
                in.setHeader("CamelBeanMethodName", prevMethod);
            }
        }
        if (!invocation.getMethod().getReturnType().equals(Void.TYPE) && value != Void.TYPE) {
            if (exchange.getPattern().isOutCapable()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting bean invocation result on the OUT message: " + value);
                }
                exchange.getOut().setBody(value);
                exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting bean invocation result on the IN message: " + value);
                }
                exchange.getIn().setBody(value);
            }
        }
        callback.done(true);
        return true;
    }

    protected Processor getProcessor() {
        return this.beanHolder.getProcessor();
    }

    public Object getBean() {
        return this.beanHolder.getBean();
    }

    public Method getMethodObject() {
        return this.methodObject;
    }

    public void setMethodObject(Method methodObject) {
        this.methodObject = methodObject;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isMultiParameterArray() {
        return this.multiParameterArray;
    }

    public void setMultiParameterArray(boolean mpArray) {
        this.multiParameterArray = mpArray;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isShorthandMethod() {
        return this.shorthandMethod;
    }

    public void setShorthandMethod(boolean shorthandMethod) {
        this.shorthandMethod = shorthandMethod;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.getProcessor());
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.getProcessor());
    }
}

