/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.component.bean.DefaultAnnotationExpressionFactory;
import org.apache.camel.language.LanguageAnnotation;
import org.apache.camel.language.NamespacePrefix;
import org.apache.camel.util.ObjectHelper;

public class XPathAnnotationExpressionFactory
extends DefaultAnnotationExpressionFactory {
    @Override
    public Expression createExpression(CamelContext camelContext, Annotation annotation, LanguageAnnotation languageAnnotation, Class<?> expressionReturnType) {
        String xpath = this.getExpressionFromAnnotation(annotation);
        XPathBuilder builder = XPathBuilder.xpath(xpath, this.getResultType(annotation));
        NamespacePrefix[] namespaces = this.getExpressionNameSpacePrefix(annotation);
        if (namespaces != null) {
            for (NamespacePrefix namespacePrefix : namespaces) {
                builder = builder.namespace(namespacePrefix.prefix(), namespacePrefix.uri());
            }
        }
        return builder;
    }

    protected Class<?> getResultType(Annotation annotation) {
        try {
            Method method = annotation.getClass().getMethod("resultType", new Class[0]);
            Object value = ObjectHelper.invokeMethod(method, annotation, new Object[0]);
            return (Class)value;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot determine the annotation: " + annotation + " as it does not have an resultType() method", e);
        }
    }

    protected NamespacePrefix[] getExpressionNameSpacePrefix(Annotation annotation) {
        try {
            Method method = annotation.getClass().getMethod("namespaces", new Class[0]);
            Object value = ObjectHelper.invokeMethod(method, annotation, new Object[0]);
            return (NamespacePrefix[])value;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot determine the annotation: " + annotation + " as it does not have an namespaces() method", e);
        }
    }
}

