/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Route;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.camel.processor.CamelLogger;
import org.slf4j.LoggerFactory;

public class ThrottlingInflightRoutePolicy
extends RoutePolicySupport {
    private final Lock lock = new ReentrantLock();
    private ThrottlingScope scope = ThrottlingScope.Route;
    private int maxInflightExchanges = 1000;
    private int resumePercentOfMax = 70;
    private int resumeInflightExchanges = 700;
    private LoggingLevel loggingLevel = LoggingLevel.INFO;
    private CamelLogger logger;

    public String toString() {
        return "ThrottlingInflightRoutePolicy[" + this.maxInflightExchanges + " / " + this.resumePercentOfMax + "% using scope " + (Object)((Object)this.scope) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExchangeDone(Route route, Exchange exchange) {
        Consumer consumer = route.getConsumer();
        int size = this.getSize(consumer, exchange);
        if (this.maxInflightExchanges > 0 && size > this.maxInflightExchanges) {
            try {
                this.lock.lock();
                this.stopConsumer(size, consumer);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            finally {
                this.lock.unlock();
            }
        }
        if ((size = this.getSize(consumer, exchange)) <= this.resumeInflightExchanges) {
            try {
                this.lock.lock();
                this.startConsumer(size, consumer);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public int getMaxInflightExchanges() {
        return this.maxInflightExchanges;
    }

    public void setMaxInflightExchanges(int maxInflightExchanges) {
        this.maxInflightExchanges = maxInflightExchanges;
        this.resumeInflightExchanges = Math.max(this.resumePercentOfMax * maxInflightExchanges / 100, 1);
    }

    public int getResumePercentOfMax() {
        return this.resumePercentOfMax;
    }

    public void setResumePercentOfMax(int resumePercentOfMax) {
        if (resumePercentOfMax < 0 || resumePercentOfMax > 100) {
            throw new IllegalArgumentException("Must be a percentage between 0 and 100, was: " + resumePercentOfMax);
        }
        this.resumePercentOfMax = resumePercentOfMax;
        this.resumeInflightExchanges = Math.max(resumePercentOfMax * this.maxInflightExchanges / 100, 1);
    }

    public ThrottlingScope getScope() {
        return this.scope;
    }

    public void setScope(ThrottlingScope scope) {
        this.scope = scope;
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public CamelLogger getLogger() {
        if (this.logger == null) {
            this.logger = this.createLogger();
        }
        return this.logger;
    }

    public void setLogger(CamelLogger logger) {
        this.logger = logger;
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    protected CamelLogger createLogger() {
        return new CamelLogger(LoggerFactory.getLogger(ThrottlingInflightRoutePolicy.class), this.getLoggingLevel());
    }

    private int getSize(Consumer consumer, Exchange exchange) {
        if (this.scope == ThrottlingScope.Context) {
            return exchange.getContext().getInflightRepository().size();
        }
        Endpoint endpoint = consumer.getEndpoint();
        return exchange.getContext().getInflightRepository().size(endpoint);
    }

    private void startConsumer(int size, Consumer consumer) throws Exception {
        boolean started = super.startConsumer(consumer);
        if (started) {
            this.getLogger().log("Throttling consumer: " + size + " <= " + this.resumeInflightExchanges + " inflight exchange by resuming consumer.");
        }
    }

    private void stopConsumer(int size, Consumer consumer) throws Exception {
        boolean stopped = super.stopConsumer(consumer);
        if (stopped) {
            this.getLogger().log("Throttling consumer: " + size + " > " + this.maxInflightExchanges + " inflight exchange by suspending consumer.");
        }
    }

    public static enum ThrottlingScope {
        Context,
        Route;

    }
}

