/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.BaseTypeConverterRegistry;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;

public class LazyLoadingTypeConverter
extends BaseTypeConverterRegistry {
    private final AtomicBoolean loaded = new AtomicBoolean();

    public LazyLoadingTypeConverter(PackageScanClassResolver resolver, Injector injector, FactoryFinder factoryFinder) {
        super(resolver, injector, factoryFinder);
    }

    @Override
    protected Object doConvertTo(Class type, Exchange exchange, Object value) {
        this.ensureLoaded();
        return super.doConvertTo(type, exchange, value);
    }

    @Override
    public TypeConverter getTypeConverter(Class<?> toType, Class<?> fromType) {
        this.ensureLoaded();
        return super.getTypeConverter(toType, fromType);
    }

    @Override
    public Set<Class<?>> getFromClassMappings() {
        this.ensureLoaded();
        return super.getFromClassMappings();
    }

    @Override
    public Map<Class<?>, TypeConverter> getToClassMappings(Class<?> fromClass) {
        this.ensureLoaded();
        return super.getToClassMappings(fromClass);
    }

    @Override
    public Map<BaseTypeConverterRegistry.TypeMapping, TypeConverter> getTypeMappings() {
        this.ensureLoaded();
        return super.getTypeMappings();
    }

    @Override
    protected TypeConverter doLookup(Class<?> toType, Class<?> fromType, boolean isSuper) {
        this.ensureLoaded();
        return super.doLookup(toType, fromType, isSuper);
    }

    private synchronized void ensureLoaded() {
        if (this.loaded.compareAndSet(false, true)) {
            try {
                super.loadTypeConverters();
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.loaded.set(false);
    }
}

