/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Comparator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.NoOutputExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.SortProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="sort")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SortDefinition
extends NoOutputExpressionNode {
    @XmlTransient
    private Comparator<Object> comparator;
    @XmlAttribute
    private String comparatorRef;

    public SortDefinition() {
    }

    public SortDefinition(Expression expression) {
        this.setExpression(new ExpressionDefinition(expression));
    }

    public SortDefinition(Expression expression, Comparator<Object> comparator) {
        this(expression);
        this.comparator = comparator;
    }

    public String toString() {
        return "sort[" + this.getExpression() + " by: " + (this.comparatorRef != null ? "ref:" + this.comparatorRef : this.comparator) + "]";
    }

    @Override
    public String getShortName() {
        return "sort";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (ObjectHelper.isNotEmpty(this.comparatorRef)) {
            this.comparator = routeContext.getCamelContext().getRegistry().lookup(this.comparatorRef, Comparator.class);
        }
        if (this.comparator == null) {
            this.comparator = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ObjectHelper.compare(o1, o2);
                }
            };
        }
        Expression exp = this.getExpression() == null ? ExpressionBuilder.bodyExpression() : this.getExpression().createExpression(routeContext);
        return new SortProcessor(exp, this.getComparator());
    }

    public Comparator<Object> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<Object> comparator) {
        this.comparator = comparator;
    }

    public String getComparatorRef() {
        return this.comparatorRef;
    }

    public void setComparatorRef(String comparatorRef) {
        this.comparatorRef = comparatorRef;
    }

    public SortDefinition comparator(Comparator<Object> comparator) {
        this.setComparator(comparator);
        return this;
    }

    public SortDefinition comparatorRef(String ref) {
        this.setComparatorRef(ref);
        return this;
    }
}

