/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.language.NamespaceAwareExpression;
import org.apache.camel.spi.ClassResolver;

@XmlRootElement(name="xquery")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XQueryExpression
extends NamespaceAwareExpression {
    @XmlAttribute
    private String type;
    @XmlTransient
    private Class<?> resultType;

    public XQueryExpression() {
    }

    public XQueryExpression(String expression) {
        super(expression);
    }

    @Override
    public String getLanguage() {
        return "xquery";
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    @Override
    protected void configureExpression(CamelContext camelContext, Expression expression) {
        super.configureExpression(camelContext, expression);
        this.updateResultType(camelContext.getClassResolver());
        if (this.resultType != null) {
            this.setProperty(expression, "resultType", this.resultType);
        }
    }

    @Override
    protected void configurePredicate(CamelContext camelContext, Predicate predicate) {
        super.configurePredicate(camelContext, predicate);
        this.updateResultType(camelContext.getClassResolver());
        if (this.resultType != null) {
            this.setProperty(predicate, "resultType", this.resultType);
        }
    }

    private void updateResultType(ClassResolver resolver) {
        if (this.resultType == null && this.type != null) {
            try {
                this.resultType = resolver.resolveMandatoryClass(this.type);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeCamelException(e);
            }
        }
    }
}

