/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChoiceProcessor
extends ServiceSupport
implements AsyncProcessor,
Navigate<Processor>,
Traceable {
    private static final transient Logger LOG = LoggerFactory.getLogger(ChoiceProcessor.class);
    private final List<FilterProcessor> filters;
    private final AsyncProcessor otherwise;

    public ChoiceProcessor(List<FilterProcessor> filters, Processor otherwise) {
        this.filters = filters;
        this.otherwise = AsyncProcessorTypeConverter.convert(otherwise);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        for (int i = 0; i < this.filters.size(); ++i) {
            FilterProcessor filter = this.filters.get(i);
            Predicate predicate = filter.getPredicate();
            boolean matches = false;
            try {
                if (predicate != null) {
                    matches = predicate.matches(exchange);
                }
            }
            catch (Throwable e) {
                exchange.setException(e);
                callback.done(true);
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("#" + i + " - " + predicate + " matches: " + matches + " for: " + exchange);
            }
            if (!matches) continue;
            return filter.processNext(exchange, callback);
        }
        if (this.otherwise != null) {
            return AsyncProcessorHelper.process(this.otherwise, exchange, callback);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("choice{");
        boolean first = true;
        for (FilterProcessor processor : this.filters) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("when ");
            builder.append(processor.getPredicate().toString());
            builder.append(": ");
            builder.append(processor.getProcessor());
        }
        if (this.otherwise != null) {
            builder.append(", otherwise: ");
            builder.append(this.otherwise);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String getTraceLabel() {
        return "choice";
    }

    public List<FilterProcessor> getFilters() {
        return this.filters;
    }

    public Processor getOtherwise() {
        return this.otherwise;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        if (this.filters != null) {
            answer.addAll(this.filters);
        }
        if (this.otherwise != null) {
            answer.add(this.otherwise);
        }
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.otherwise != null || this.filters != null && !this.filters.isEmpty();
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.filters, this.otherwise);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.otherwise, this.filters);
    }
}

