/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.util.ServiceHelper;

public class InterceptorToAsyncProcessorBridge
extends ServiceSupport
implements AsyncProcessor {
    private final AsyncProcessor interceptor;
    private volatile AsyncProcessor target;
    private volatile ThreadLocal<AsyncCallback> callback = new ThreadLocal();
    private volatile ThreadLocal<Boolean> interceptorDone = new ThreadLocal();

    public InterceptorToAsyncProcessorBridge(Processor interceptor) {
        this(interceptor, null);
    }

    public InterceptorToAsyncProcessorBridge(Processor interceptor, AsyncProcessor target) {
        this.interceptor = AsyncProcessorTypeConverter.convert(interceptor);
        this.target = target;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        boolean done = this.interceptor.process(exchange, this.callback.get());
        this.interceptorDone.set(done);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        this.callback.set(callback);
        try {
            boolean done = this.target.process(exchange, callback);
            if (this.interceptorDone.get() != null) {
                boolean bl = this.interceptorDone.get();
                return bl;
            }
            boolean bl = done;
            return bl;
        }
        finally {
            this.callback.remove();
            this.interceptorDone.remove();
        }
    }

    public void setTarget(Processor target) {
        this.target = AsyncProcessorTypeConverter.convert(target);
    }

    public String toString() {
        return "AsyncBridge[" + this.interceptor.toString() + "]";
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.target, this.interceptor);
    }

    @Override
    protected void doStop() throws Exception {
        this.callback.remove();
        this.interceptorDone.remove();
        ServiceHelper.stopServices(this.interceptor, this.target);
    }
}

