/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelayProcessorSupport;
import org.apache.camel.processor.Traceable;

public class Throttler
extends DelayProcessorSupport
implements Traceable {
    private long maximumRequestsPerPeriod;
    private long timePeriodMillis;
    private volatile TimeSlot slot;

    public Throttler(Processor processor, long maximumRequestsPerPeriod) {
        this(processor, maximumRequestsPerPeriod, 1000L, null);
    }

    public Throttler(Processor processor, long maximumRequestsPerPeriod, long timePeriodMillis, ScheduledExecutorService executorService) {
        super(processor, executorService);
        this.maximumRequestsPerPeriod = maximumRequestsPerPeriod;
        this.timePeriodMillis = timePeriodMillis;
    }

    @Override
    public String toString() {
        return "Throttler[requests: " + this.maximumRequestsPerPeriod + " per: " + this.timePeriodMillis + " (ms) to: " + this.getProcessor() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "throttle[" + this.maximumRequestsPerPeriod + " per: " + this.timePeriodMillis + "]";
    }

    public long getMaximumRequestsPerPeriod() {
        return this.maximumRequestsPerPeriod;
    }

    public void setMaximumRequestsPerPeriod(long maximumRequestsPerPeriod) {
        this.maximumRequestsPerPeriod = maximumRequestsPerPeriod;
    }

    public long getTimePeriodMillis() {
        return this.timePeriodMillis;
    }

    public void setTimePeriodMillis(long timePeriodMillis) {
        this.timePeriodMillis = timePeriodMillis;
    }

    @Override
    protected long calculateDelay(Exchange exchange) {
        TimeSlot slot = this.nextSlot();
        if (!slot.isActive()) {
            long delay = slot.startTime - this.currentSystemTime();
            return delay;
        }
        return 0L;
    }

    protected synchronized TimeSlot nextSlot() {
        if (this.slot == null) {
            this.slot = new TimeSlot();
        }
        if (this.slot.isFull()) {
            this.slot = this.slot.next();
        }
        this.slot.assign();
        return this.slot;
    }

    protected class TimeSlot {
        private volatile long capacity;
        private final long duration;
        private final long startTime;

        protected TimeSlot() {
            this(System.currentTimeMillis());
        }

        protected TimeSlot(long startTime) {
            this.capacity = Throttler.this.maximumRequestsPerPeriod;
            this.duration = Throttler.this.timePeriodMillis;
            this.startTime = startTime;
        }

        protected void assign() {
            --this.capacity;
        }

        protected TimeSlot next() {
            return new TimeSlot(Math.max(System.currentTimeMillis(), this.startTime + this.duration));
        }

        protected boolean isActive() {
            return this.startTime <= System.currentTimeMillis();
        }

        protected boolean isFull() {
            return this.capacity <= 0L;
        }
    }
}

